/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssProvideNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRequireNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssStringNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class CheckDependencyNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String provideName = CssAtRuleNode.Type.PROVIDE.getCanonicalName();
    private static final String requireName = CssAtRuleNode.Type.REQUIRE.getCanonicalName();
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final boolean suppressDependencyCheck;
    private Set<String> provides = Sets.newLinkedHashSet();

    public CheckDependencyNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this(visitController, errorManager, true);
    }

    public CheckDependencyNodes(MutatingVisitController visitController, ErrorManager errorManager, boolean suppressDependencyCheck) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.suppressDependencyCheck = suppressDependencyCheck;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        void var4_7;
        String atRuleName = node.getName().getValue();
        if (provideName.equals(atRuleName)) {
            CssLiteralNode arg = this.extractArgument(node);
            if (arg == null) return false;
            CssProvideNode cssProvideNode = this.createProvideNode(node, arg);
        } else {
            if (!requireName.equals(atRuleName)) return true;
            CssLiteralNode arg = this.extractArgument(node);
            if (arg == null) return false;
            CssRequireNode cssRequireNode = this.createRequireNode(node, arg);
        }
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssNode[]{var4_7}), false);
        return true;
    }

    private CssLiteralNode extractArgument(CssUnknownAtRuleNode node) {
        String atRuleName = node.getName().getValue();
        if (node.getType().hasBlock()) {
            this.reportError("@" + atRuleName + " with block", node);
            return null;
        }
        List<CssValueNode> params = node.getParameters();
        if (params.isEmpty()) {
            this.reportError("@" + atRuleName + " without name", node);
            return null;
        }
        CssNode nameNode = params.get(0);
        if (!(nameNode instanceof CssStringNode)) {
            this.reportError("@" + atRuleName + " without a quoted string as name", node);
            return null;
        }
        CssStringNode nameStringNode = (CssStringNode)nameNode;
        return new CssLiteralNode(nameStringNode.getValue());
    }

    private CssProvideNode createProvideNode(CssUnknownAtRuleNode node, CssLiteralNode provideArgument) {
        CssProvideNode provideNode = new CssProvideNode(provideArgument, node.getComments(), node.getSourceCodeLocation());
        String provide = provideNode.getProvide();
        if (this.provides.contains(provide)) {
            this.reportError("Duplicate provide for: " + provide, node);
        }
        this.provides.add(provide);
        return provideNode;
    }

    private CssRequireNode createRequireNode(CssUnknownAtRuleNode node, CssLiteralNode requireArgument) {
        CssRequireNode requireNode = new CssRequireNode(requireArgument, node.getComments(), node.getSourceCodeLocation());
        String require = requireNode.getRequire();
        if (!this.provides.contains(require)) {
            this.reportError("Missing provide for: " + require, node);
        }
        return requireNode;
    }

    private void reportError(String message, CssNode node) {
        if (!this.suppressDependencyCheck) {
            this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
            this.visitController.removeCurrentNode();
        }
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    @VisibleForTesting
    List<String> getProvidesInOrder() {
        return ImmutableList.copyOf(this.provides);
    }
}

