/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssClassSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCombinatorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFontFaceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssIdSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyframesNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMediaRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPseudoClassNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPseudoElementNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.passes.CompactPrinter;

public class ChunkCompactPrinter<T>
extends CompactPrinter {
    private final T chunk;
    private boolean printSelector;

    public ChunkCompactPrinter(CssTree tree, T chunk) {
        super(tree);
        this.chunk = chunk;
    }

    @Override
    public boolean enterRuleset(CssRulesetNode ruleset) {
        for (CssSelectorNode selector : ruleset.getSelectors().childIterable()) {
            if (!this.chunk.equals(selector.getChunk())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean enterSelector(CssSelectorNode selector) {
        this.printSelector = this.chunk.equals(selector.getChunk());
        if (this.printSelector) {
            return super.enterSelector(selector);
        }
        return true;
    }

    @Override
    public void leaveSelector(CssSelectorNode selector) {
        if (this.printSelector) {
            super.leaveSelector(selector);
        }
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode media) {
        this.printSelector = this.chunk.equals(media.getChunk());
        if (!this.printSelector) {
            return false;
        }
        return super.enterMediaRule(media);
    }

    @Override
    public void leaveMediaRule(CssMediaRuleNode media) {
        if (this.printSelector) {
            super.leaveMediaRule(media);
        }
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode keyframes) {
        this.printSelector = this.chunk.equals(keyframes.getChunk());
        if (!this.printSelector) {
            return false;
        }
        return super.enterKeyframesRule(keyframes);
    }

    @Override
    public void leaveKeyframesRule(CssKeyframesNode keyframes) {
        if (this.printSelector) {
            super.leaveKeyframesRule(keyframes);
        }
    }

    @Override
    public boolean enterFontFace(CssFontFaceNode cssFontFaceNode) {
        this.printSelector = this.chunk.equals(cssFontFaceNode.getChunk());
        if (!this.printSelector) {
            return false;
        }
        return super.enterFontFace(cssFontFaceNode);
    }

    @Override
    public void leaveFontFace(CssFontFaceNode cssFontFaceNode) {
        if (this.printSelector) {
            super.leaveFontFace(cssFontFaceNode);
        }
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        if (this.printSelector) {
            return super.enterClassSelector(node);
        }
        return true;
    }

    @Override
    public void leaveClassSelector(CssClassSelectorNode node) {
        if (this.printSelector) {
            super.leaveClassSelector(node);
        }
    }

    @Override
    public boolean enterIdSelector(CssIdSelectorNode node) {
        if (this.printSelector) {
            return super.enterIdSelector(node);
        }
        return true;
    }

    @Override
    public void leaveIdSelector(CssIdSelectorNode node) {
        if (this.printSelector) {
            super.leaveIdSelector(node);
        }
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        if (this.printSelector) {
            return super.enterPseudoClass(node);
        }
        return true;
    }

    @Override
    public void leavePseudoClass(CssPseudoClassNode node) {
        if (this.printSelector) {
            super.leavePseudoClass(node);
        }
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        if (this.printSelector) {
            return super.enterPseudoElement(node);
        }
        return true;
    }

    @Override
    public void leavePseudoElement(CssPseudoElementNode node) {
        if (this.printSelector) {
            super.leavePseudoElement(node);
        }
    }

    @Override
    public boolean enterAttributeSelector(CssAttributeSelectorNode node) {
        if (this.printSelector) {
            return super.enterAttributeSelector(node);
        }
        return true;
    }

    @Override
    public void leaveAttributeSelector(CssAttributeSelectorNode node) {
        if (this.printSelector) {
            super.leaveAttributeSelector(node);
        }
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (this.printSelector) {
            return super.enterCombinator(combinator);
        }
        return true;
    }

    @Override
    public void leaveCombinator(CssCombinatorNode combinator) {
        if (this.printSelector) {
            super.leaveCombinator(combinator);
        }
    }
}

