/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssProvideNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRequireNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.LinkedListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class CollectProvideNamespaces
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final Logger logger = Logger.getLogger(CollectProvideNamespaces.class.getName());
    private static final Pattern OVERRIDE_REGEX = Pattern.compile("/\\*\\s+@overrideSelector\\s+\\{(.*)\\}\\s+\\*/");
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final Map<String, String> filenameProvideMap = Maps.newHashMap();
    private final ListMultimap<String, String> filenameRequireMap = LinkedListMultimap.create();
    private final ListMultimap<String, String> defProvideMap = LinkedListMultimap.create();
    private final ListMultimap<String, String> defmixinProvideMap = LinkedListMultimap.create();

    public Map<String, String> getFilenameProvideMap() {
        return ImmutableMap.copyOf(this.filenameProvideMap);
    }

    public ListMultimap<String, String> getFilenameRequireMap() {
        return ImmutableListMultimap.copyOf(this.filenameRequireMap);
    }

    public ListMultimap<String, String> getDefProvideMap() {
        return ImmutableListMultimap.copyOf(this.defProvideMap);
    }

    public ListMultimap<String, String> getDefmixinProvideMap() {
        return ImmutableListMultimap.copyOf(this.defmixinProvideMap);
    }

    public CollectProvideNamespaces(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterProvideNode(CssProvideNode node) {
        Preconditions.checkState((node.getSourceCodeLocation() != null ? 1 : 0) != 0);
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        this.filenameProvideMap.put(filename, node.getProvide());
        return true;
    }

    @Override
    public boolean enterRequireNode(CssRequireNode node) {
        Preconditions.checkState((node.getSourceCodeLocation() != null ? 1 : 0) != 0);
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        this.filenameRequireMap.put((Object)filename, (Object)node.getRequire());
        return true;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        if (node.getSourceCodeLocation() == null) {
            return true;
        }
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        String provideNamespace = this.filenameProvideMap.get(filename);
        if (provideNamespace == null) {
            return true;
        }
        this.defProvideMap.put((Object)node.getName().getValue(), (Object)provideNamespace);
        return true;
    }

    @Override
    public boolean enterMixinDefinition(CssMixinDefinitionNode node) {
        if (node.getSourceCodeLocation() == null) {
            return true;
        }
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        String provideNamespace = this.filenameProvideMap.get(filename);
        if (provideNamespace == null) {
            return true;
        }
        Preconditions.checkArgument((provideNamespace != null ? 1 : 0) != 0);
        this.defmixinProvideMap.put((Object)node.getDefinitionName(), (Object)provideNamespace);
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

