/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssHexColorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ColorValueOptimizer
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final Logger logger = Logger.getLogger(ColorValueOptimizer.class.getName());
    private static final CssFunctionNode.Function RGB = CssFunctionNode.Function.byName("rgb");
    private MutatingVisitController visitController;

    public ColorValueOptimizer(MutatingVisitController visitController) {
        this.visitController = visitController;
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode function) {
        if (function.getFunction() == RGB) {
            try {
                String hexValue = ColorValueOptimizer.parseRgbArguments(function);
                if (ColorValueOptimizer.canShortenHexString(hexValue)) {
                    hexValue = ColorValueOptimizer.shortenHexString(hexValue);
                }
                CssHexColorNode optimizedColor = new CssHexColorNode(hexValue, function.getSourceCodeLocation());
                ArrayList temp = Lists.newArrayList();
                temp.add(optimizedColor);
                this.visitController.replaceCurrentBlockChildWith(temp, true);
            }
            catch (NumberFormatException nfe) {
                logger.info("Error parsing rgb() function: " + nfe.toString());
            }
        }
        return true;
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        CssHexColorNode color;
        if (node instanceof CssHexColorNode && ColorValueOptimizer.canShortenHexString((color = (CssHexColorNode)node).getValue())) {
            String hexValue = ColorValueOptimizer.shortenHexString(color.getValue());
            CssHexColorNode optimizedColor = new CssHexColorNode(hexValue, node.getSourceCodeLocation());
            ArrayList temp = Lists.newArrayList();
            temp.add(optimizedColor);
            this.visitController.replaceCurrentBlockChildWith(temp, true);
        }
        return true;
    }

    @VisibleForTesting
    static String parseRgbArguments(CssFunctionNode function) throws NumberFormatException {
        CssFunctionArgumentsNode args = function.getArguments();
        int numArgs = 0;
        StringBuilder hexValue = new StringBuilder("#");
        for (CssValueNode rgbValue : args.getChildren()) {
            if (rgbValue instanceof CssNumericNode) {
                ++numArgs;
                CssNumericNode numericValue = (CssNumericNode)rgbValue;
                int scalarValue = Integer.parseInt(numericValue.getNumericPart());
                if ("%".equals(numericValue.getUnit())) {
                    scalarValue = (int)(255.0 * (double)scalarValue / 100.0 + 0.5);
                } else if (!CssNumericNode.NO_UNITS.equals(numericValue.getUnit())) {
                    throw new NumberFormatException("rgb arguments must be scalar or %. Bad value:" + numericValue.toString());
                }
                if (scalarValue < 0) {
                    logger.info("Out of range argument to rgb(): " + numericValue);
                    scalarValue = 0;
                }
                if (scalarValue > 255) {
                    logger.info("Out of range argument to rgb(): " + numericValue);
                    scalarValue = 255;
                }
                if (scalarValue < 16) {
                    hexValue.append('0');
                }
                hexValue.append(Integer.toHexString(scalarValue));
                continue;
            }
            if (rgbValue instanceof CssLiteralNode && ",".equals(rgbValue.getValue())) continue;
            throw new NumberFormatException("Expected numeric value:" + rgbValue.getValue());
        }
        if (numArgs != 3) {
            throw new NumberFormatException("Invalid number of arguments to rgb().");
        }
        return hexValue.toString();
    }

    @VisibleForTesting
    static boolean canShortenHexString(String hex) {
        Preconditions.checkArgument((boolean)hex.startsWith("#"));
        return hex.length() == 7 && hex.charAt(1) == hex.charAt(2) && hex.charAt(3) == hex.charAt(4) && hex.charAt(5) == hex.charAt(6);
    }

    @VisibleForTesting
    static String shortenHexString(String hex) {
        StringBuilder optimizedHexValue = new StringBuilder("#");
        optimizedHexValue.append(hex.charAt(1));
        optimizedHexValue.append(hex.charAt(3));
        optimizedHexValue.append(hex.charAt(5));
        return optimizedHexValue.toString();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

