/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssComponentNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssLiteralNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssStringNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.List;

public class CreateComponentNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String componentName = CssAtRuleNode.Type.COMPONENT.getCanonicalName();
    private static final String abstractComponentName = CssAtRuleNode.Type.ABSTRACT_COMPONENT.getCanonicalName();
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;

    public CreateComponentNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        String name = node.getName().getValue();
        if (name.equals(componentName) || name.equals(abstractComponentName)) {
            CssNode nameNode;
            if (!node.getType().hasBlock()) {
                this.reportError("@" + name + " without block", node);
                return;
            }
            List<CssValueNode> params = node.getParameters();
            CssLiteralNode parentNode = null;
            int paramSize = params.size();
            CssComponentNode.PrefixStyle prefixStyle = CssComponentNode.PrefixStyle.LITERAL;
            if (paramSize == 0) {
                prefixStyle = CssComponentNode.PrefixStyle.CASE_CONVERT;
                nameNode = new CssLiteralNode("$package", node.getSourceCodeLocation());
            } else {
                nameNode = params.get(0);
                if (nameNode instanceof CssStringNode) {
                    prefixStyle = CssComponentNode.PrefixStyle.CASE_CONVERT;
                    nameNode = new CssLiteralNode(((CssStringNode)nameNode).getValue(), nameNode.getSourceCodeLocation());
                } else if (!(nameNode instanceof CssLiteralNode)) {
                    this.reportError("@" + name + " without a valid literal as name", node);
                    return;
                }
                if (paramSize != 1) {
                    if (paramSize == 3) {
                        CssNode extendNode = params.get(1);
                        if (!(extendNode instanceof CssLiteralNode) || !((CssLiteralNode)extendNode).getValue().equals("extends")) {
                            this.reportError("@" + name + " with invalid second parameter (expects 'extends')", node);
                            return;
                        }
                        CssNode parentCssNode = params.get(2);
                        if (!(parentCssNode instanceof CssLiteralNode)) {
                            this.reportError("@" + name + " with invalid literal as parent name", node);
                            return;
                        }
                        parentNode = (CssLiteralNode)parentCssNode;
                    } else {
                        this.reportError("@" + name + " with invalid number of parameters", node);
                        return;
                    }
                }
            }
            Preconditions.checkState((boolean)(node.getBlock() instanceof CssBlockNode));
            CssComponentNode comp = new CssComponentNode((CssLiteralNode)nameNode, parentNode, name.equals(abstractComponentName), prefixStyle, (CssBlockNode)node.getBlock());
            comp.setComments(node.getComments());
            comp.setSourceCodeLocation(node.getSourceCodeLocation());
            this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssNode[]{comp}), false);
        }
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
        this.visitController.removeCurrentNode();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

