/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMixinNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.List;

public class CreateMixins
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String NO_BLOCK_ERROR_MESSAGE = "This @-rule has to have a block";
    @VisibleForTesting
    static final String BLOCK_ERROR_MESSAGE = "This @-rule is not allowed to have a block";
    @VisibleForTesting
    static final String ONLY_DECLARATION_BLOCK_ERROR_MESSAGE = "Only declaration blocks are allowed for this @-rule";
    @VisibleForTesting
    static final String INVALID_PARAMETERS_ERROR_MESSAGE = "This @-rule has invalid parameters";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;

    public CreateMixins(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        String mixinName = CssAtRuleNode.Type.MIXIN.getCanonicalName();
        String mixinDefinitionName = CssAtRuleNode.Type.DEFMIXIN.getCanonicalName();
        if (node.getName().getValue().equals(mixinName)) {
            this.createMixin(node);
        } else if (node.getName().getValue().equals(mixinDefinitionName)) {
            this.createMixinDefinition(node);
        }
        return true;
    }

    private void createMixin(CssUnknownAtRuleNode node) {
        if (node.getBlock() != null) {
            this.reportError(BLOCK_ERROR_MESSAGE, node);
            return;
        }
        List<CssValueNode> params = node.getParameters();
        if (params.size() != 1 || !(params.get(0) instanceof CssFunctionNode)) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        CssFunctionNode function = (CssFunctionNode)params.get(0);
        String name = function.getFunctionName();
        CssFunctionArgumentsNode arguments = function.getArguments();
        CssMixinNode mixin = new CssMixinNode(name, arguments, node.getSourceCodeLocation());
        mixin.setComments(node.getComments());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssMixinNode[]{mixin}), true);
    }

    private void createMixinDefinition(CssUnknownAtRuleNode node) {
        if (node.getBlock() == null) {
            this.reportError(NO_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
            this.reportError(ONLY_DECLARATION_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        List<CssValueNode> params = node.getParameters();
        if (params.size() != 1 || !(params.get(0) instanceof CssFunctionNode)) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        CssDeclarationBlockNode block = (CssDeclarationBlockNode)node.getBlock();
        CssFunctionNode function = (CssFunctionNode)params.get(0);
        String name = function.getFunctionName();
        CssFunctionArgumentsNode arguments = function.getArguments();
        CssMixinDefinitionNode mixinDefinition = new CssMixinDefinitionNode(name, arguments, block, node.getSourceCodeLocation());
        mixinDefinition.setComments(node.getComments());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssMixinDefinitionNode[]{mixinDefinition}), true);
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
        this.visitController.removeCurrentNode();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

