/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRefinerNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRootNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.ast.SkippingTreeVisitor;
import java.util.Iterator;

public class MergeAdjacentRulesetNodesWithSameDeclarations
extends SkippingTreeVisitor
implements CssCompilerPass {
    private final CssTree tree;
    private final MutatingVisitController visitController;

    public MergeAdjacentRulesetNodesWithSameDeclarations(CssTree tree) {
        this(tree, false);
    }

    public MergeAdjacentRulesetNodesWithSameDeclarations(CssTree tree, boolean skipping) {
        super(skipping);
        this.tree = tree;
        this.visitController = tree.getMutatingVisitController();
    }

    @Override
    public boolean enterTree(CssRootNode root) {
        this.tree.resetRulesetNodesToRemove();
        return true;
    }

    @Override
    public boolean enterBlock(CssBlockNode block) {
        if (block.numChildren() <= 1) {
            return true;
        }
        Iterator iterator = block.getChildIterator();
        CssRulesetNode ruleToMergeTo = null;
        while (iterator.hasNext()) {
            CssNode node = (CssNode)iterator.next();
            if (!(node instanceof CssRulesetNode) || this.hasProblematicSelectors((CssRulesetNode)node) || !this.canModifyRuleset((CssRulesetNode)node)) {
                ruleToMergeTo = null;
                continue;
            }
            CssRulesetNode currentRule = (CssRulesetNode)node;
            if (ruleToMergeTo != null && ruleToMergeTo.getDeclarations().toString().equals(currentRule.getDeclarations().toString())) {
                for (CssSelectorNode decl : currentRule.getSelectors().childIterable()) {
                    ruleToMergeTo.addSelector(decl);
                }
                this.tree.getRulesetNodesToRemove().addRulesetNode(currentRule);
                continue;
            }
            ruleToMergeTo = currentRule;
        }
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private boolean hasProblematicSelectors(CssRulesetNode rule) {
        for (CssSelectorNode selector : rule.getSelectors().childIterable()) {
            for (CssRefinerNode refiner : selector.getRefiners().childIterable()) {
                if (refiner.getRefinerType() != CssRefinerNode.Refiner.PSEUDO_ELEMENT) continue;
                return true;
            }
        }
        return false;
    }
}

