/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssClassSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCombinatorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFontFaceNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssFunctionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssIdSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssImportRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyframeRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyframesNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssMediaRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPageRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPageSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPseudoClassNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssPseudoElementNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRefinerNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorListNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssStringNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;

public class PrettyPrinter
extends DefaultTreeVisitor
implements CssCompilerPass {
    private StringBuilder sb = null;
    private String prettyPrintedString = null;
    private String indent = "";
    private final VisitController visitController;
    private boolean stripQuotes = false;

    public PrettyPrinter(VisitController visitController) {
        this.visitController = visitController;
    }

    public void setStripQuotes(boolean stripQuotes) {
        this.stripQuotes = stripQuotes;
    }

    @Override
    public boolean enterImportRule(CssImportRuleNode node) {
        this.sb.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(" ");
            if (param instanceof CssStringNode) {
                CssStringNode n = (CssStringNode)param;
                this.sb.append(n.toString(CssStringNode.SHORT_ESCAPER));
                continue;
            }
            this.sb.append(param.getValue());
        }
        return true;
    }

    @Override
    public void leaveImportRule(CssImportRuleNode node) {
        this.sb.append(";\n");
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode node) {
        this.sb.append(node.getType().toString());
        if (node.getParameters().size() > 0 || node.getType().hasBlock() && node.getBlock() != null) {
            this.sb.append(" ");
        }
        return true;
    }

    @Override
    public void leaveMediaRule(CssMediaRuleNode node) {
    }

    @Override
    public boolean enterPageRule(CssPageRuleNode node) {
        this.sb.append(node.getType().toString());
        this.sb.append(' ');
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(param.getValue());
        }
        if (node.getParametersCount() > 0) {
            this.sb.append(' ');
        }
        return true;
    }

    @Override
    public boolean enterPageSelector(CssPageSelectorNode node) {
        this.sb.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(" ");
            this.sb.append(param.getValue());
        }
        return true;
    }

    @Override
    public boolean enterFontFace(CssFontFaceNode node) {
        this.sb.append(node.getType().toString());
        return true;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        this.sb.append(this.indent);
        this.sb.append((Object)node.getType());
        this.sb.append(" ");
        this.sb.append(node.getName());
        this.sb.append(" ");
        return true;
    }

    @Override
    public void leaveDefinition(CssDefinitionNode node) {
        this.deleteEndingIfEndingIs(" ");
        this.sb.append(";\n");
    }

    @Override
    public boolean enterRuleset(CssRulesetNode ruleset) {
        this.sb.append(this.indent);
        return true;
    }

    @Override
    public boolean enterKeyframeRuleset(CssKeyframeRulesetNode ruleset) {
        this.sb.append(this.indent);
        return true;
    }

    @Override
    public boolean enterDeclarationBlock(CssDeclarationBlockNode block) {
        this.deleteEndingIfEndingIs(" ");
        this.sb.append(" {\n");
        this.indent = this.indent + "  ";
        return true;
    }

    @Override
    public void leaveDeclarationBlock(CssDeclarationBlockNode block) {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
        this.sb.append(this.indent);
        this.sb.append("}\n");
    }

    @Override
    public boolean enterBlock(CssBlockNode block) {
        if (block.getParent() instanceof CssUnknownAtRuleNode || block.getParent() instanceof CssMediaRuleNode) {
            this.sb.append("{\n");
            this.indent = this.indent + "  ";
        }
        return true;
    }

    @Override
    public void leaveBlock(CssBlockNode block) {
        if (block.getParent() instanceof CssMediaRuleNode) {
            this.sb.append("}\n");
            this.indent = this.indent.substring(0, this.indent.length() - 2);
        }
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        this.sb.append(this.indent);
        if (declaration.hasStarHack()) {
            this.sb.append('*');
        }
        this.sb.append(declaration.getPropertyName().getValue());
        this.sb.append(": ");
        return true;
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode declaration) {
        this.deleteEndingIfEndingIs(" ");
        this.sb.append(";\n");
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        Preconditions.checkArgument((!(node instanceof CssCompositeValueNode) ? 1 : 0) != 0);
        String v = node.toString();
        if (this.stripQuotes && node.getParent() instanceof CssDefinitionNode) {
            v = this.maybeStripQuotes(v);
        }
        this.sb.append(v);
        if (!node.inFunArgs()) {
            this.sb.append(" ");
        }
        return true;
    }

    @Override
    public boolean enterCompositeValueNodeOperator(CssCompositeValueNode parent) {
        this.sb.append(parent.getOperator().getOperatorName());
        if (!parent.inFunArgs()) {
            this.sb.append(" ");
        }
        return true;
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode node) {
        this.sb.append(node.getFunctionName());
        this.sb.append("(");
        return true;
    }

    @Override
    public void leaveFunctionNode(CssFunctionNode node) {
        this.deleteEndingIfEndingIs(" ");
        this.sb.append(") ");
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        String v = node.toString();
        if (this.stripQuotes && node.getParent().getParent() instanceof CssFunctionNode && ((CssFunctionNode)node.getParent().getParent()).getFunctionName().equals("url")) {
            v = this.maybeStripQuotes(v);
        }
        this.sb.append(v);
        return !(node instanceof CssCompositeValueNode);
    }

    @Override
    public boolean enterSelector(CssSelectorNode selector) {
        String name = selector.getSelectorName();
        if (name != null) {
            this.sb.append(name);
        }
        return true;
    }

    @Override
    public void leaveSelector(CssSelectorNode selector) {
        this.sb.append(", ");
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterIdSelector(CssIdSelectorNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        this.sb.append(node.getPrefix());
        this.sb.append(node.getRefinerName());
        switch (node.getFunctionType()) {
            case NTH: {
                this.sb.append(node.getArgument().replace(" ", ""));
                this.sb.append(")");
                break;
            }
            case LANG: {
                this.sb.append(node.getArgument());
                this.sb.append(")");
            }
        }
        return true;
    }

    @Override
    public void leavePseudoClass(CssPseudoClassNode node) {
        if (node.getFunctionType() == CssPseudoClassNode.FunctionType.NOT) {
            this.deleteEndingIfEndingIs(", ");
            this.sb.append(")");
        }
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterAttributeSelector(CssAttributeSelectorNode node) {
        this.sb.append(node.getPrefix());
        this.sb.append(node.getAttributeName());
        this.sb.append(node.getMatchSymbol());
        this.sb.append(node.getValue());
        this.sb.append(node.getSuffix());
        return true;
    }

    private void appendRefiner(CssRefinerNode node) {
        this.sb.append(node.getPrefix());
        this.sb.append(node.getRefinerName());
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (combinator != null) {
            this.sb.append(combinator.getCombinatorType().getCanonicalName());
        }
        return true;
    }

    @Override
    public void leaveCombinator(CssCombinatorNode combinator) {
        this.deleteEndingIfEndingIs(", ");
    }

    @Override
    public void leaveSelectorBlock(CssSelectorListNode node) {
        this.deleteEndingIfEndingIs(", ");
    }

    @Override
    public void leaveConditionalBlock(CssConditionalBlockNode block) {
        this.sb.append("\n");
    }

    @Override
    public boolean enterConditionalRule(CssConditionalRuleNode node) {
        if (node.getType() != CssAtRuleNode.Type.IF) {
            this.sb.append(" ");
        } else {
            this.sb.append(this.indent);
        }
        this.sb.append((Object)node.getType());
        if (node.getParametersCount() > 0) {
            this.sb.append(" ");
            boolean firstParameter = true;
            for (CssValueNode value : node.getParameters()) {
                if (!firstParameter) {
                    this.sb.append(" ");
                }
                firstParameter = false;
                this.sb.append(value.toString());
            }
        }
        this.sb.append(" {\n");
        this.indent = this.indent + "  ";
        return true;
    }

    @Override
    public void leaveConditionalRule(CssConditionalRuleNode node) {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
        this.sb.append(this.indent);
        this.sb.append("}");
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        this.sb.append(this.indent);
        this.sb.append('@').append(node.getName().toString());
        if (node.getParameters().size() > 0 || node.getType().hasBlock() && node.getBlock() != null) {
            this.sb.append(" ");
        }
        return true;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        if (node.getType().hasBlock()) {
            if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
                this.indent = this.indent.substring(0, this.indent.length() - 2);
                this.sb.append(this.indent);
                this.sb.append("}\n");
            }
        } else {
            this.deleteEndingIfEndingIs(" ");
            this.sb.append(";\n");
        }
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode node) {
        this.sb.append(this.indent);
        this.sb.append('@').append(node.getName().toString());
        for (CssValueNode param : node.getParameters()) {
            this.sb.append(" ");
            this.sb.append(param.getValue());
        }
        if (node.getType().hasBlock()) {
            this.sb.append(" {\n");
            this.indent = this.indent + "  ";
        }
        return true;
    }

    @Override
    public void leaveKeyframesRule(CssKeyframesNode node) {
        if (node.getType().hasBlock()) {
            this.indent = this.indent.substring(0, this.indent.length() - 2);
            this.sb.append(this.indent);
            this.sb.append("}\n");
        } else {
            this.sb.append(";\n");
        }
    }

    @Override
    public boolean enterKey(CssKeyNode key) {
        String value = key.getKeyValue();
        if (value != null) {
            this.sb.append(value);
        }
        return true;
    }

    @Override
    public void leaveKey(CssKeyNode key) {
        this.sb.append(", ");
    }

    @Override
    public void leaveKeyBlock(CssKeyListNode node) {
        this.deleteEndingIfEndingIs(", ");
    }

    private void deleteEndingIfEndingIs(String s) {
        if (this.sb.subSequence(this.sb.length() - s.length(), this.sb.length()).equals(s)) {
            this.sb.delete(this.sb.length() - s.length(), this.sb.length());
        }
    }

    public String getPrettyPrintedString() {
        return this.prettyPrintedString;
    }

    @Override
    public void runPass() {
        this.sb = new StringBuilder();
        this.visitController.startVisit(this);
        this.prettyPrintedString = this.sb.toString();
    }

    private String maybeStripQuotes(String v) {
        if (v.startsWith("'") || v.startsWith("\"")) {
            assert (v.endsWith(v.substring(0, 1)));
            v = v.substring(1, v.length() - 1);
        }
        return v;
    }
}

