/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssKeyframesNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;

public class ProcessKeyframes
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String KEYFRAMES_NOT_ALLOWED_ERROR_MESSAGE = "a @keyframes rule occured but the option for it is disabled";
    @VisibleForTesting
    static final String WRONG_KEY_VALUE_ERROR_MESSAGE = "the value of the key is not between 0% and 100%";
    static final String INVALID_NUMBER_ERROR_MESSAGE = "the value of the key is invalid (not 'from', 'to', or 'XXX.XXX%')";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final boolean keyframesAllowed;
    private final boolean simplifyCss;

    public ProcessKeyframes(MutatingVisitController visitController, ErrorManager errorManager, boolean keyframesAllowed, boolean simplifyCss) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.keyframesAllowed = keyframesAllowed;
        this.simplifyCss = simplifyCss;
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode node) {
        if (!this.keyframesAllowed) {
            this.errorManager.report(new GssError(KEYFRAMES_NOT_ALLOWED_ERROR_MESSAGE, node.getSourceCodeLocation()));
        }
        return this.keyframesAllowed;
    }

    @Override
    public boolean enterKey(CssKeyNode node) {
        if (!this.keyframesAllowed) {
            return false;
        }
        String value = node.getKeyValue();
        float percentage = -1.0f;
        if (value.contains("%")) {
            try {
                percentage = Float.parseFloat(value.substring(0, value.length() - 1));
            }
            catch (NumberFormatException e) {
                this.errorManager.report(new GssError(INVALID_NUMBER_ERROR_MESSAGE, node.getSourceCodeLocation()));
                return false;
            }
            if (!this.checkRangeOfPercentage(node, percentage)) {
                return false;
            }
        } else if (!value.equals("from") && !value.equals("to")) {
            this.errorManager.report(new GssError(INVALID_NUMBER_ERROR_MESSAGE, node.getSourceCodeLocation()));
            return false;
        }
        if (this.simplifyCss) {
            this.compactRepresentation(node, percentage);
        }
        return true;
    }

    private boolean checkRangeOfPercentage(CssKeyNode node, float percentage) {
        if (percentage < 0.0f || percentage > 100.0f) {
            this.errorManager.report(new GssError(WRONG_KEY_VALUE_ERROR_MESSAGE, node.getSourceCodeLocation()));
            return false;
        }
        return true;
    }

    @VisibleForTesting
    void compactRepresentation(CssKeyNode node, float percentage) {
        if (node.getKeyValue().equals("from")) {
            node.setKeyValue("0%");
        } else if (percentage == 100.0f) {
            node.setKeyValue("to");
        } else if (percentage != -1.0f) {
            String percentageStr = Float.toString(percentage);
            if (0.0f < percentage && percentage < 1.0f) {
                percentageStr = percentageStr.substring(1, percentageStr.length());
            }
            if ((percentageStr = percentageStr.replaceAll("0+$", "")).endsWith(".")) {
                percentageStr = percentageStr.substring(0, percentageStr.length() - 1);
            }
            node.setKeyValue(percentageStr + "%");
        }
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

