/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.common.css.compiler.passes;

import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDeclarationNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRulesetNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssSelectorNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.common.css.compiler.ast.Property;
import com.google.gwt.thirdparty.common.css.compiler.ast.SkippingTreeVisitor;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Ordering;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class UnsafeMergeRulesetNodes
implements CssCompilerPass {
    private static final Set<String> ORDER_DEPENDENT_PARTITIONS = ImmutableSet.of((Object)"border");
    private final CssTree tree;
    private final boolean byPartition;
    private final boolean skipping;
    @VisibleForTesting
    static final Comparator<Object> TO_STRING_COMPARATOR = Ordering.usingToString();
    @VisibleForTesting
    static final Comparator<Iterable<?>> TO_STRING_ITERABLE_COMPARATOR = UnsafeMergeRulesetNodes.createIterableComparator(TO_STRING_COMPARATOR);
    @VisibleForTesting
    static final Comparator<CssDeclarationNode> DECLARATION_COMPARATOR = new Comparator<CssDeclarationNode>(){

        @Override
        public int compare(CssDeclarationNode o1, CssDeclarationNode o2) {
            Property property1 = o1.getPropertyName().getProperty();
            Property property2 = o2.getPropertyName().getProperty();
            if (property1.getShorthands().contains(property2.getName())) {
                return 1;
            }
            if (property2.getShorthands().contains(property1.getName())) {
                return -1;
            }
            return TO_STRING_COMPARATOR.compare(o1, o2);
        }
    };

    public UnsafeMergeRulesetNodes(CssTree tree, boolean byPartition, boolean skipping) {
        this.tree = tree;
        this.byPartition = byPartition;
        this.skipping = skipping;
    }

    @Override
    public void runPass() {
        this.replace(this.collect());
    }

    private CollectPhaseTreeVisitor collect() {
        CollectPhaseTreeVisitor collectPhaseVisitor = new CollectPhaseTreeVisitor(this.tree.getMutatingVisitController(), this.byPartition, this.skipping);
        collectPhaseVisitor.runPass();
        return collectPhaseVisitor;
    }

    private void replace(CollectPhaseTreeVisitor collectPhaseVisitor) {
        if (collectPhaseVisitor.getPlaceholderRuleset() == null) {
            return;
        }
        ArrayList rulesets = Lists.newArrayList();
        for (Map.Entry<CssDeclarationNode, Collection<CssSelectorNode>> entry : collectPhaseVisitor.getDecToSels()) {
            rulesets.add(this.makeOneDeclarationRuleset(entry.getKey(), (Iterable<CssSelectorNode>)entry.getValue()));
        }
        for (Map.Entry<Object, Collection<CssSelectorNode>> entry : collectPhaseVisitor.getPartitions()) {
            rulesets.add(this.makePartitionRuleset((Iterable)entry.getKey(), (Iterable<CssSelectorNode>)entry.getValue()));
        }
        new ReplacePhaseTreeVisitor(this.tree.getMutatingVisitController(), rulesets, collectPhaseVisitor.getPlaceholderRuleset()).runPass();
    }

    private CssRulesetNode makeOneDeclarationRuleset(CssDeclarationNode dec, Iterable<CssSelectorNode> sels) {
        CssRulesetNode ruleset = new CssRulesetNode(new CssDeclarationBlockNode());
        ruleset.addDeclaration(dec);
        for (CssSelectorNode sel : sels) {
            ruleset.addSelector(sel.deepCopy());
        }
        return ruleset;
    }

    private CssRulesetNode makePartitionRuleset(Iterable<CssDeclarationNode> decs, Iterable<CssSelectorNode> sels) {
        CssRulesetNode ruleset = new CssRulesetNode(new CssDeclarationBlockNode());
        for (CssDeclarationNode dec : decs) {
            ruleset.addDeclaration(dec.deepCopy());
        }
        for (CssSelectorNode sel : sels) {
            ruleset.addSelector(sel.deepCopy());
        }
        return ruleset;
    }

    private static <T> Comparator<Iterable<? extends T>> createIterableComparator(final Comparator<T> elementComparator) {
        return new Comparator<Iterable<? extends T>>(){

            @Override
            public int compare(Iterable<? extends T> o1, Iterable<? extends T> o2) {
                int c;
                Iterator i1 = o1.iterator();
                Iterator i2 = o2.iterator();
                do {
                    if (i1.hasNext() && !i2.hasNext()) {
                        return 1;
                    }
                    if (!i1.hasNext() && i2.hasNext()) {
                        return -1;
                    }
                    if (i1.hasNext() || i2.hasNext()) continue;
                    return 0;
                } while ((c = elementComparator.compare(i1.next(), i2.next())) == 0);
                return c;
            }
        };
    }

    private static class Partitioner {
        private final Map<String, Partition> partitions = Maps.newHashMap();

        private Partitioner() {
        }

        public void add(CssDeclarationNode declaration, CssSelectorNode selector) {
            String partitionName = declaration.getPropertyName().getPartition();
            this.getPartition(partitionName).add(declaration, selector);
        }

        public Map<Collection<CssDeclarationNode>, Set<CssSelectorNode>> getMap() {
            TreeMap map = Maps.newTreeMap(TO_STRING_ITERABLE_COMPARATOR);
            for (Partition partition : this.partitions.values()) {
                partition.addTo(map);
            }
            return map;
        }

        private Partition getPartition(String partitionName) {
            Partition partition = this.partitions.get(partitionName);
            if (partition == null) {
                partition = Partition.newPartition(partitionName);
                this.partitions.put(partitionName, partition);
            }
            return partition;
        }
    }

    private static class OrderDependentPartition
    extends Partition {
        private final Map<CssSelectorNode, List<CssDeclarationNode>> inMap = Maps.newTreeMap(TO_STRING_COMPARATOR);

        private OrderDependentPartition(String partition) {
            super(partition);
        }

        @Override
        public void add(CssDeclarationNode declaration, CssSelectorNode selector) {
            this.getDeclarations(selector).add(declaration);
        }

        @Override
        public void addTo(Map<Collection<CssDeclarationNode>, Set<CssSelectorNode>> outMap) {
            for (Map.Entry<CssSelectorNode, List<CssDeclarationNode>> entry : this.inMap.entrySet()) {
                this.getSelectorsByDeclarations((Collection<CssDeclarationNode>)entry.getValue(), outMap).add(entry.getKey());
            }
        }

        private List<CssDeclarationNode> getDeclarations(CssSelectorNode selector) {
            LinkedList declarations = this.inMap.get(selector);
            if (declarations == null) {
                declarations = Lists.newLinkedList();
                this.inMap.put(selector, declarations);
            }
            return declarations;
        }
    }

    private static class OrderIndependentPartition
    extends Partition {
        private final Multimap<CssSelectorNode, CssDeclarationNode> inMap = TreeMultimap.create(TO_STRING_COMPARATOR, DECLARATION_COMPARATOR);

        private OrderIndependentPartition(String partition) {
            super(partition);
        }

        @Override
        public void add(CssDeclarationNode declaration, CssSelectorNode selector) {
            this.inMap.put((Object)selector, (Object)declaration);
        }

        @Override
        public void addTo(Map<Collection<CssDeclarationNode>, Set<CssSelectorNode>> outMap) {
            for (Map.Entry entry : this.inMap.asMap().entrySet()) {
                this.getSelectorsByDeclarations((Collection)entry.getValue(), outMap).add((CssSelectorNode)entry.getKey());
            }
        }
    }

    private static abstract class Partition {
        protected final String partition;

        protected Partition(String partition) {
            this.partition = partition;
        }

        public static Partition newPartition(String partition) {
            return ORDER_DEPENDENT_PARTITIONS.contains(partition) ? new OrderDependentPartition(partition) : new OrderIndependentPartition(partition);
        }

        public abstract void add(CssDeclarationNode var1, CssSelectorNode var2);

        public abstract void addTo(Map<Collection<CssDeclarationNode>, Set<CssSelectorNode>> var1);

        protected Set<CssSelectorNode> getSelectorsByDeclarations(Collection<CssDeclarationNode> declarations, Map<Collection<CssDeclarationNode>, Set<CssSelectorNode>> map) {
            TreeSet selectors = map.get(declarations);
            if (selectors == null) {
                selectors = Sets.newTreeSet(TO_STRING_COMPARATOR);
                map.put(declarations, selectors);
            }
            return selectors;
        }
    }

    private static class ReplacePhaseTreeVisitor
    extends DefaultTreeVisitor
    implements CssCompilerPass {
        private final MutatingVisitController visitController;
        private final List<CssNode> rulesets;
        private final CssRulesetNode placeholderRuleset;

        public ReplacePhaseTreeVisitor(MutatingVisitController visitController, List<CssNode> rulesets, CssRulesetNode placeholderRuleset) {
            this.visitController = visitController;
            this.rulesets = rulesets;
            this.placeholderRuleset = placeholderRuleset;
        }

        @Override
        public boolean enterRuleset(CssRulesetNode ruleset) {
            if (ruleset == this.placeholderRuleset) {
                this.visitController.replaceCurrentBlockChildWith(this.rulesets, false);
            }
            return true;
        }

        @Override
        public void runPass() {
            this.visitController.startVisit(this);
        }
    }

    private static class CollectPhaseTreeVisitor
    extends SkippingTreeVisitor
    implements CssCompilerPass {
        private final MutatingVisitController visitController;
        private final boolean byPartition;
        private final Multimap<CssDeclarationNode, CssSelectorNode> decToSel = TreeMultimap.create(DECLARATION_COMPARATOR, TO_STRING_COMPARATOR);
        private final Partitioner partitioner = new Partitioner();
        private CssRulesetNode placeholderRuleset = null;

        public CollectPhaseTreeVisitor(MutatingVisitController visitController, boolean byPartition, boolean skipping) {
            super(skipping);
            this.visitController = visitController;
            this.byPartition = byPartition;
        }

        @Override
        public boolean enterRuleset(CssRulesetNode ruleset) {
            if (this.canModifyRuleset(ruleset)) {
                this.collectRuleset(ruleset);
                this.deleteRuleset();
            }
            return true;
        }

        @Override
        public void runPass() {
            this.visitController.startVisit(this);
        }

        Iterable<Map.Entry<CssDeclarationNode, Collection<CssSelectorNode>>> getDecToSels() {
            return this.decToSel.asMap().entrySet();
        }

        Iterable<Map.Entry<Collection<CssDeclarationNode>, Set<CssSelectorNode>>> getPartitions() {
            return this.partitioner.getMap().entrySet();
        }

        CssRulesetNode getPlaceholderRuleset() {
            return this.placeholderRuleset;
        }

        private void collectRuleset(CssRulesetNode ruleset) {
            for (CssNode abstractDecl : ruleset.getDeclarations().childIterable()) {
                Preconditions.checkState((boolean)(abstractDecl instanceof CssDeclarationNode));
                CssDeclarationNode dec = (CssDeclarationNode)abstractDecl;
                boolean inPartition = this.byPartition || ORDER_DEPENDENT_PARTITIONS.contains(dec.getPropertyName().getPartition());
                for (CssSelectorNode sel : ruleset.getSelectors().childIterable()) {
                    if (inPartition) {
                        this.partitioner.add(dec, sel);
                        continue;
                    }
                    this.decToSel.put((Object)dec, (Object)sel);
                }
            }
        }

        private void deleteRuleset() {
            if (this.placeholderRuleset == null) {
                this.placeholderRuleset = new CssRulesetNode(new CssDeclarationBlockNode());
                this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)this.placeholderRuleset), false);
            } else {
                this.visitController.removeCurrentNode();
            }
        }
    }
}

