/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import java.util.Arrays;

class BitField {
    private byte[] bytes = new byte[0];

    public void setBit(int index) {
        if (index < 0) {
            return;
        }
        int byteIndex = index / 8;
        int newByteSize = byteIndex + 1;
        if (this.bytes.length < newByteSize) {
            this.bytes = Arrays.copyOf(this.bytes, newByteSize);
        }
        int bitIndex = index % 8;
        int mask = 1 << bitIndex;
        int n = byteIndex;
        this.bytes[n] = (byte)(this.bytes[n] | mask);
    }

    public boolean isBitSet(int index) {
        int byteIndex = index / 8;
        if (byteIndex >= this.bytes.length) {
            return false;
        }
        int bitIndex = index % 8;
        int mask = 1 << bitIndex;
        return (this.bytes[byteIndex] & mask) != 0;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.bytes.length; ++i) {
            int byteValue = 0;
            for (int j = i * 8 + 7; j >= i * 8; --j) {
                byteValue = 2 * byteValue + (this.isBitSet(j) ? 1 : 0);
            }
            result.append(BitField.getHexPair(byteValue));
        }
        return result.toString();
    }

    public static String getHexPair(int byteValue) {
        Preconditions.checkArgument((byteValue >= 0 && byteValue < 256 ? 1 : 0) != 0);
        int firstHex = (int)Math.floor(byteValue / 16);
        int secondHex = byteValue % 16;
        return Integer.toHexString(firstHex) + Integer.toHexString(secondHex);
    }
}

