/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.JSDocInfo;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.List;
import java.util.Set;

class CollapseVariableDeclarations
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Collapse> collapses = Lists.newArrayList();
    private final Set<Node> nodesToCollapse = Sets.newHashSet();

    CollapseVariableDeclarations(AbstractCompiler compiler) {
        Preconditions.checkState((!compiler.getLifeCycleStage().isNormalized() ? 1 : 0) != 0);
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.collapses.clear();
        this.nodesToCollapse.clear();
        NodeTraversal.traverse(this.compiler, root, new GatherCollapses());
        if (!this.collapses.isEmpty()) {
            this.applyCollapses();
            this.compiler.reportCodeChange();
        }
    }

    private boolean isNamedParameter(Scope.Var v) {
        return v.getParentNode().isParamList();
    }

    private void applyCollapses() {
        for (Collapse collapse : this.collapses) {
            Node var = new Node(118);
            var.copyInformationFrom(collapse.startNode);
            collapse.parent.addChildBefore(var, collapse.startNode);
            boolean redeclaration = false;
            Node n = collapse.startNode;
            while (n != collapse.endNode) {
                Node next = n.getNext();
                Preconditions.checkState((var.getNext() == n ? 1 : 0) != 0);
                collapse.parent.removeChildAfter(var);
                if (n.isVar()) {
                    while (n.hasChildren()) {
                        var.addChildToBack(n.removeFirstChild());
                    }
                } else {
                    Node assign = n.getFirstChild();
                    Node lhs = assign.getFirstChild();
                    Preconditions.checkState((boolean)lhs.isName());
                    Node rhs = assign.getLastChild();
                    lhs.addChildToBack(rhs.detachFromParent());
                    var.addChildToBack(lhs.detachFromParent());
                    redeclaration = true;
                }
                n = next;
            }
            if (!redeclaration) continue;
            JSDocInfo info = new JSDocInfo();
            info.addSuppression("duplicate");
            var.setJSDocInfo(info);
        }
    }

    private class GatherCollapses
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<Scope.Var> blacklistedVars = Sets.newHashSet();

        private GatherCollapses() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isVar()) {
                this.blacklistStubVars(t, n);
            }
            if (!n.isVar() && !this.canBeRedeclared(n, t.getScope())) {
                return;
            }
            if (CollapseVariableDeclarations.this.nodesToCollapse.contains(n)) {
                return;
            }
            if (parent.isIf()) {
                return;
            }
            Node varNode = n;
            boolean hasVar = n.isVar();
            boolean hasNodesToCollapse = false;
            for (n = n.getNext(); n != null && (n.isVar() || this.canBeRedeclared(n, t.getScope())); n = n.getNext()) {
                if (n.isVar()) {
                    this.blacklistStubVars(t, n);
                    hasVar = true;
                }
                CollapseVariableDeclarations.this.nodesToCollapse.add(n);
                hasNodesToCollapse = true;
            }
            if (hasNodesToCollapse && hasVar) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(varNode);
                CollapseVariableDeclarations.this.collapses.add(new Collapse(varNode, n, parent));
            }
        }

        private void blacklistStubVars(NodeTraversal t, Node varNode) {
            for (Node child = varNode.getFirstChild(); child != null; child = child.getNext()) {
                if (child.getFirstChild() != null) continue;
                this.blacklistedVars.add(t.getScope().getVar(child.getString()));
            }
        }

        private boolean canBeRedeclared(Node n, Scope s) {
            if (!NodeUtil.isExprAssign(n)) {
                return false;
            }
            Node assign = n.getFirstChild();
            Node lhs = assign.getFirstChild();
            if (!lhs.isName()) {
                return false;
            }
            Scope.Var var = s.getVar(lhs.getString());
            return var != null && var.getScope() == s && !CollapseVariableDeclarations.this.isNamedParameter(var) && !this.blacklistedVars.contains(var);
        }
    }

    private static class Collapse {
        final Node startNode;
        final Node endNode;
        final Node parent;

        Collapse(Node startNode, Node endNode, Node parent) {
            this.startNode = startNode;
            this.endNode = endNode;
            this.parent = parent;
        }
    }
}

