/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class ConstCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType CONST_REASSIGNED_VALUE_ERROR = DiagnosticType.error("JSC_CONSTANT_REASSIGNED_VALUE_ERROR", "constant {0} assigned a value more than once");
    private final AbstractCompiler compiler;
    private final Set<Scope.Var> initializedConstants;

    public ConstCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.initializedConstants = new HashSet<Scope.Var>();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 38: {
                if (parent == null || !parent.isVar() || !n.hasChildren()) break;
                String name = n.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (!this.isConstant(var)) break;
                if (this.initializedConstants.contains(var)) {
                    this.reportError(t, n, name);
                    break;
                }
                this.initializedConstants.add(var);
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (!this.isConstant(var)) break;
                if (this.initializedConstants.contains(var)) {
                    this.reportError(t, n, name);
                    break;
                }
                this.initializedConstants.add(var);
                break;
            }
            case 102: 
            case 103: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Scope.Var var = t.getScope().getVar(name);
                if (!this.isConstant(var)) break;
                this.reportError(t, n, name);
                break;
            }
        }
    }

    private boolean isConstant(Scope.Var var) {
        return var != null && var.isConst();
    }

    void reportError(NodeTraversal t, Node n, String name) {
        this.compiler.report(t.makeError(n, CONST_REASSIGNED_VALUE_ERROR, name));
    }
}

