/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class MoveFunctionDeclarations
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<JSModule, List<Node>> functions;

    MoveFunctionDeclarations(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.functions = Maps.newHashMap();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        for (Map.Entry<JSModule, List<Node>> entry : this.functions.entrySet()) {
            JSModule module = entry.getKey();
            Node addingRoot = this.compiler.getNodeForCodeInsertion(module);
            for (Node n : Lists.reverse(entry.getValue())) {
                addingRoot.addChildToFront(n);
            }
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        Node gramps = n.getAncestor(2);
        return gramps == null || !gramps.isScript();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (parent == null || !parent.isScript()) {
            return;
        }
        if (NodeUtil.isFunctionDeclaration(n)) {
            parent.removeChild(n);
            this.compiler.reportCodeChange();
            JSModule module = t.getModule();
            ArrayList moduleFunctions = this.functions.get(module);
            if (moduleFunctions == null) {
                moduleFunctions = Lists.newArrayList();
                this.functions.put(module, moduleFunctions);
            }
            moduleFunctions.add(n);
        }
    }
}

