/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerInput;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.regex.Pattern;

public class ProcessCommonJSModules
implements CompilerPass {
    private static final String MODULE_SLASH = "/";
    public static final String DEFAULT_FILENAME_PREFIX = "./";
    private static final String MODULE_NAME_SEPARATOR = "\\$";
    private static final String MODULE_NAME_PREFIX = "module$";
    private final AbstractCompiler compiler;
    private final String filenamePrefix;
    private final boolean reportDependencies;
    private JSModule module;

    ProcessCommonJSModules(AbstractCompiler compiler, String filenamePrefix) {
        this(compiler, filenamePrefix, true);
    }

    ProcessCommonJSModules(AbstractCompiler compiler, String filenamePrefix, boolean reportDependencies) {
        this.compiler = compiler;
        this.filenamePrefix = filenamePrefix.endsWith(MODULE_SLASH) ? filenamePrefix : filenamePrefix + MODULE_SLASH;
        this.reportDependencies = reportDependencies;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ProcessCommonJsModulesCallback());
    }

    String guessCJSModuleName(String filename) {
        return ProcessCommonJSModules.toModuleName(this.normalizeSourceName(filename));
    }

    JSModule getModule() {
        return this.module;
    }

    public static String toModuleName(String filename) {
        return MODULE_NAME_PREFIX + filename.replaceAll("^\\." + Pattern.quote(MODULE_SLASH), "").replaceAll(Pattern.quote(MODULE_SLASH), MODULE_NAME_SEPARATOR).replaceAll("\\.js$", "").replaceAll("-", "_");
    }

    public static String toModuleName(String requiredFilename, String currentFilename) {
        requiredFilename = requiredFilename.replaceAll("\\.js$", "");
        currentFilename = currentFilename.replaceAll("\\.js$", "");
        if (requiredFilename.startsWith(DEFAULT_FILENAME_PREFIX) || requiredFilename.startsWith("../")) {
            try {
                requiredFilename = new URI(currentFilename).resolve(new URI(requiredFilename)).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return ProcessCommonJSModules.toModuleName(requiredFilename);
    }

    private String normalizeSourceName(String filename) {
        if ((filename = filename.replace("\\", MODULE_SLASH)).indexOf(this.filenamePrefix) == 0) {
            filename = filename.substring(this.filenamePrefix.length());
        }
        return filename;
    }

    private class SuffixVarsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private static final String EXPORTS = "exports";
        private final String suffix;

        SuffixVarsCallback(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                String name = n.getString();
                if (this.suffix.equals(name)) {
                    return;
                }
                if (EXPORTS.equals(name)) {
                    n.setString(this.suffix);
                    n.putProp(40, EXPORTS);
                } else {
                    Scope.Var var = t.getScope().getVar(name);
                    if (var != null && var.isGlobal()) {
                        n.setString(name + "$$" + this.suffix);
                        n.putProp(40, name);
                    }
                }
            }
        }
    }

    private class ProcessCommonJsModulesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private int scriptNodeCount = 0;
        private Set<String> modulesWithExports = Sets.newHashSet();

        private ProcessCommonJsModulesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isCall() && n.getChildCount() == 2 && "require".equals(n.getFirstChild().getQualifiedName()) && n.getChildAtIndex(1).isString()) {
                this.visitRequireCall(t, n, parent);
            }
            if (n.isScript()) {
                ++this.scriptNodeCount;
                this.visitScript(t, n);
            }
            if (n.isGetProp() && "module.exports".equals(n.getQualifiedName())) {
                this.visitModuleExports(n);
            }
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            String moduleName = ProcessCommonJSModules.toModuleName(require.getChildAtIndex(1).getString(), ProcessCommonJSModules.this.normalizeSourceName(t.getSourceName()));
            Node moduleRef = IR.name(moduleName).srcref(require);
            parent.replaceChild(require, moduleRef);
            Node script = this.getCurrentScriptNode(parent);
            if (ProcessCommonJSModules.this.reportDependencies) {
                t.getInput().addRequire(moduleName);
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(moduleName))).copyInformationFromForTree(require));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void visitScript(NodeTraversal t, Node script) {
            Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"ProcessCommonJSModules supports only one invocation per CompilerInput / script node");
            String moduleName = ProcessCommonJSModules.this.guessCJSModuleName(script.getSourceFileName());
            script.addChildToFront(IR.var(IR.name(moduleName), IR.objectlit(new Node[0])).copyInformationFromForTree(script));
            if (ProcessCommonJSModules.this.reportDependencies) {
                CompilerInput ci = t.getInput();
                ci.addProvide(moduleName);
                JSModule m = new JSModule(moduleName);
                m.addAndOverrideModule(ci);
                ProcessCommonJSModules.this.module = m;
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("provide")), IR.string(moduleName))).copyInformationFromForTree(script));
            this.emitOptionalModuleExportsOverride(script, moduleName);
            NodeTraversal.traverse(ProcessCommonJSModules.this.compiler, script, new SuffixVarsCallback(moduleName));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void emitOptionalModuleExportsOverride(Node script, String moduleName) {
            if (!this.modulesWithExports.contains(moduleName)) {
                return;
            }
            Node moduleExportsProp = IR.getprop(IR.name(moduleName), IR.string("module$exports"));
            script.addChildToBack(IR.ifNode(moduleExportsProp, IR.block(IR.exprResult(IR.assign(IR.name(moduleName), moduleExportsProp.cloneTree())))).copyInformationFromForTree(script));
        }

        private void visitModuleExports(Node prop) {
            String moduleName = ProcessCommonJSModules.this.guessCJSModuleName(prop.getSourceFileName());
            Node module = prop.getChildAtIndex(0);
            module.putProp(40, "module");
            module.setString(moduleName);
            Node exports = prop.getChildAtIndex(1);
            exports.putProp(40, "exports");
            exports.setString("module$exports");
            this.modulesWithExports.add(moduleName);
        }

        private Node getCurrentScriptNode(Node n) {
            while (!n.isScript()) {
                n = n.getParent();
            }
            return n;
        }
    }
}

