/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp.fuzzing;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.DiscreteDistribution;
import com.google.gwt.thirdparty.javascript.jscomp.fuzzing.Scope;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Random;

public class ScopeManager {
    private ArrayDeque<Scope> scopeStack = new ArrayDeque();
    private Random random;
    private int numSym;

    public ScopeManager(Random random) {
        this.random = random;
        Scope globalScope = new Scope();
        globalScope.symbols = Lists.newArrayList((Object[])new String[]{"Array", "Boolean", "Function", "Number", "Object", "RegExp", "String", "Error", "JSON", "Math", "NaN", "undefined"});
        this.numSym = globalScope.symbols.size();
        this.scopeStack.push(globalScope);
    }

    public void addFunctionScope() {
        Scope newScope = new Scope();
        newScope.symbols = Lists.newArrayList((Object[])new String[]{"arguments"});
        ++this.numSym;
        this.scopeStack.push(newScope);
    }

    public void removeScope() {
        this.numSym -= this.localSymbols().size();
        this.scopeStack.pop();
    }

    public void addSymbol(String symbol2) {
        this.localSymbols().add(symbol2);
        ++this.numSym;
    }

    public void removeSymbol(String symbol2) {
        if (this.localSymbols().remove(symbol2)) {
            --this.numSym;
        }
    }

    private ArrayList<String> localSymbols() {
        return this.scopeStack.peek().symbols;
    }

    public Scope localScope() {
        return this.scopeStack.peek();
    }

    public int getSize() {
        return this.numSym;
    }

    public int getNumScopes() {
        return this.scopeStack.size();
    }

    public boolean hasNonLocals() {
        return this.scopeStack.size() > 1;
    }

    public String getRandomSymbol(boolean excludeLocal) {
        if (excludeLocal) {
            Preconditions.checkArgument((this.getNumScopes() > 1 ? 1 : 0) != 0);
        } else {
            Preconditions.checkArgument((this.getNumScopes() > 0 ? 1 : 0) != 0);
        }
        ArrayList<String> symbols = this.getRandomScope((boolean)excludeLocal).symbols;
        String sym2 = (String)symbols.get(this.random.nextInt(symbols.size()));
        if (excludeLocal && this.localSymbols().indexOf(sym2) != -1) {
            return null;
        }
        return sym2;
    }

    private Scope getRandomScope(boolean excludeLocal) {
        Scope s;
        int i;
        ArrayList<Scope> scopes = new ArrayList<Scope>(this.scopeStack);
        ArrayList weights = Lists.newArrayListWithCapacity((int)this.getNumScopes());
        for (i = 0; i < this.scopeStack.size() - 1; ++i) {
            s = scopes.get(i);
            weights.add(Double.valueOf(s.symbols.size()));
        }
        if (!excludeLocal) {
            s = scopes.get(i);
            weights.add(Double.valueOf(s.symbols.size()));
        }
        DiscreteDistribution<Scope> distribution = new DiscreteDistribution<Scope>(this.random, scopes, weights);
        return distribution.nextItem();
    }
}

