/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.head;

import com.google.gwt.thirdparty.javascript.rhino.head.ast.ArrayLiteral;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.Assignment;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.AstNode;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.AstRoot;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.CatchClause;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.Comment;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ConditionalExpression;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.DoLoop;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ElementGet;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ExpressionStatement;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ForInLoop;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ForLoop;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.FunctionCall;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.FunctionNode;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.IfStatement;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.InfixExpression;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.LabeledStatement;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.Loop;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.Name;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ObjectLiteral;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ObjectProperty;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ParenthesizedExpression;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ReturnStatement;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.SwitchCase;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.SwitchStatement;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.ThrowStatement;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.TryStatement;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.UnaryExpression;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.VariableDeclaration;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.VariableInitializer;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.WhileLoop;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.WithStatement;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachJsDocs {
    private Comment currentJsdoc;
    private int capos;
    private boolean attachOnlyToParen = false;
    private AstNode possibleJsdocTarget;
    private int possibleApos;

    private boolean finishesAfterJsdoc(AstNode n, int napos) {
        return this.capos < napos + n.getLength() - 1;
    }

    private AstNode siblingFinishesAfterJsdoc(AstNode n, int parapos) {
        AstNode next;
        for (next = (AstNode)n.getNext(); next != null && !this.finishesAfterJsdoc(next, parapos + next.getPosition()); next = (AstNode)next.getNext()) {
        }
        return next;
    }

    public void attachComments(AstRoot root, List<Comment> comments) {
        if (comments == null) {
            return;
        }
        AstNode n = root;
        int napos = root.getPosition();
        int parapos = 0;
        int lastcapos = -1;
        Iterator<Comment> i$ = comments.iterator();
        while (i$.hasNext()) {
            Comment c;
            this.currentJsdoc = c = i$.next();
            this.capos = this.currentJsdoc.getAbsolutePosition();
            if (this.capos <= lastcapos) {
                throw new RuntimeException("The list of jsdoc comments isn't sorted.");
            }
            lastcapos = this.capos;
            while (n != root && !this.finishesAfterJsdoc(n, napos)) {
                AstNode tmp = n.getParent();
                if (tmp != null && this.finishesAfterJsdoc(tmp, parapos) && (tmp = this.siblingFinishesAfterJsdoc(n, parapos)) != null) {
                    n = tmp;
                    break;
                }
                n = n.getParent();
                napos = parapos;
                parapos = n == root ? 0 : napos - n.getPosition();
            }
            NodePos np = this.attachComment(n, parapos);
            n = np.n;
            napos = np.apos;
            parapos = n == root ? 0 : napos - n.getPosition();
        }
    }

    private NodePos attachComment(AstNode n, int parapos) {
        int napos = parapos + n.getPosition();
        if (this.finishesAfterJsdoc(n, napos)) {
            if (this.capos < napos && !this.attachToChildren(n, napos)) {
                return this.setJsdoc(n, napos);
            }
        } else {
            return null;
        }
        int ntype = n.getType();
        switch (ntype) {
            case 120: 
            case 121: {
                return new NodePos(n, napos);
            }
            case 115: {
                NodePos res;
                SwitchCase cas = (SwitchCase)n;
                if (!cas.isDefault() && (res = this.attachComment(cas.getExpression(), napos)) != null) {
                    return res;
                }
                if (cas.getStatements() != null) {
                    for (AstNode stm : cas.getStatements()) {
                        res = this.attachComment(stm, napos);
                        if (res == null) continue;
                        return res;
                    }
                }
                return new NodePos(n, napos);
            }
            case 118: {
                DoLoop dl = (DoLoop)n;
                NodePos res = this.attachComment(dl.getBody(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < dl.getWhilePosition()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(dl.getCondition(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 133: 
            case 134: {
                NodePos res = n instanceof ExpressionStatement ? this.attachComment(((ExpressionStatement)n).getExpression(), napos) : this.attachComment(((LabeledStatement)n).getStatement(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 119: {
                Loop loop = (Loop)n;
                NodePos res = n instanceof ForInLoop ? this.attachForInHeader((ForInLoop)loop, napos) : this.attachForLoopHeader((ForLoop)loop, napos);
                if (res != null) {
                    return res;
                }
                res = this.attachComment(loop.getBody(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 112: {
                IfStatement ifstm = (IfStatement)n;
                NodePos res = this.attachComment(ifstm.getCondition(), napos);
                if (res != null) {
                    return res;
                }
                res = this.attachComment(ifstm.getThenPart(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < ifstm.getElsePosition()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(ifstm.getElsePart(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 109: {
                NodePos res;
                FunctionNode fun = (FunctionNode)n;
                Name nam = fun.getFunctionName();
                if (nam != null && (res = this.attachComment(nam, napos)) != null) {
                    return res;
                }
                for (AstNode param : fun.getParams()) {
                    res = this.attachComment(param, napos);
                    if (res == null) continue;
                    return res;
                }
                res = this.attachComment(fun.getBody(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 4: {
                NodePos res;
                AstNode retValue = ((ReturnStatement)n).getReturnValue();
                if (retValue != null && (res = this.attachComment(retValue, napos)) != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 114: {
                SwitchStatement sw = (SwitchStatement)n;
                NodePos res = this.attachComment(sw.getExpression(), napos);
                if (res != null) {
                    return res;
                }
                for (SwitchCase c : sw.getCases()) {
                    res = this.attachComment(c, napos);
                }
                return new NodePos(n, napos);
            }
            case 50: {
                NodePos res = this.attachComment(((ThrowStatement)n).getExpression(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 81: {
                TryStatement t = (TryStatement)n;
                NodePos res = this.attachComment(t.getTryBlock(), napos);
                if (res != null) {
                    return res;
                }
                for (CatchClause cc : t.getCatchClauses()) {
                    int catchstart = napos + cc.getPosition();
                    if (this.capos < catchstart) {
                        return new NodePos(n, napos);
                    }
                    res = this.attachComment(cc.getVarName(), catchstart);
                    if (res != null) {
                        return res;
                    }
                    res = this.attachComment(cc.getBody(), catchstart);
                    if (res == null) continue;
                    return res;
                }
                int finpos = t.getFinallyPosition();
                if (finpos != -1) {
                    if (this.capos < finpos) {
                        return new NodePos(n, napos);
                    }
                    res = this.attachComment(t.getFinallyBlock(), napos);
                    if (res != null) {
                        return res;
                    }
                }
                return new NodePos(n, napos);
            }
            case 122: {
                if (n instanceof VariableDeclaration) {
                    for (VariableInitializer vi : ((VariableDeclaration)n).getVariables()) {
                        NodePos res = this.attachComment(vi, napos);
                        if (res == null) continue;
                        return res;
                    }
                } else {
                    NodePos res = this.attachComment(((VariableInitializer)n).getInitializer(), napos);
                    if (res != null) {
                        return res;
                    }
                }
                return new NodePos(n, napos);
            }
            case 117: {
                WhileLoop wh = (WhileLoop)n;
                NodePos res = this.attachComment(wh.getCondition(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < wh.getRp()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(wh.getBody(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 123: {
                WithStatement w = (WithStatement)n;
                NodePos res = this.attachComment(w.getExpression(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < w.getRp()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(w.getStatement(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 46: 
            case 47: 
            case 52: 
            case 53: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 151: 
            case 152: {
                InfixExpression ie = (InfixExpression)n;
                NodePos res = this.attachComment(ie.getLeft(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < ie.getOperatorPosition()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(ie.getRight(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 65: {
                for (AstNode elm : ((ArrayLiteral)n).getElements()) {
                    NodePos res = this.attachComment(elm, napos);
                    if (res == null) continue;
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 106: 
            case 107: 
            case 126: {
                UnaryExpression ue = (UnaryExpression)n;
                NodePos res = this.attachComment(ue.getOperand(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 30: 
            case 38: {
                FunctionCall call = (FunctionCall)n;
                NodePos res = this.attachComment(call.getTarget(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < call.getLp()) {
                    return new NodePos(n, napos);
                }
                for (AstNode param : call.getArguments()) {
                    res = this.attachComment(param, napos);
                    if (res == null) continue;
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 36: {
                ElementGet elm = (ElementGet)n;
                NodePos res = this.attachComment(elm.getTarget(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < elm.getLb()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(elm.getElement(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 102: {
                ConditionalExpression hook = (ConditionalExpression)n;
                NodePos res = this.attachComment(hook.getTestExpression(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < hook.getQuestionMarkPosition()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(hook.getTrueExpression(), napos);
                if (res != null) {
                    return res;
                }
                if (this.capos < hook.getColonPosition()) {
                    return new NodePos(n, napos);
                }
                res = this.attachComment(hook.getFalseExpression(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 87: {
                NodePos res = this.attachComment(((ParenthesizedExpression)n).getExpression(), napos);
                if (res != null) {
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 66: {
                for (ObjectProperty prop : ((ObjectLiteral)n).getElements()) {
                    NodePos res = this.attachComment(prop, napos);
                    if (res == null) continue;
                    return res;
                }
                return new NodePos(n, napos);
            }
            case 129: 
            case 136: {
                for (AstNode kid = (AstNode)n.getFirstChild(); kid != null; kid = (AstNode)kid.getNext()) {
                    NodePos res = this.attachComment(kid, napos);
                    if (res == null) continue;
                    return res;
                }
                return new NodePos(n, napos);
            }
        }
        throw new RuntimeException("Can't attach jsdoc to unknown node: " + ntype);
    }

    private NodePos attachForInHeader(ForInLoop fi, int fipos) {
        if (this.capos < fi.getLp()) {
            return new NodePos(fi, fipos);
        }
        NodePos res = this.attachComment(fi.getIterator(), fipos);
        if (res != null) {
            return res;
        }
        if (this.capos < fi.getInPosition()) {
            return new NodePos(fi, fipos);
        }
        res = this.attachComment(fi.getIteratedObject(), fipos);
        if (res != null) {
            return res;
        }
        if (this.capos < fi.getRp()) {
            return new NodePos(fi, fipos);
        }
        return null;
    }

    private NodePos attachForLoopHeader(ForLoop fl, int flpos) {
        if (this.capos < fl.getLp()) {
            return new NodePos(fl, flpos);
        }
        NodePos res = this.attachComment(fl.getInitializer(), flpos);
        if (res != null) {
            return res;
        }
        res = this.attachComment(fl.getCondition(), flpos);
        if (res != null) {
            return res;
        }
        res = this.attachComment(fl.getIncrement(), flpos);
        if (res != null) {
            return res;
        }
        if (this.capos < fl.getRp()) {
            return new NodePos(fl, flpos);
        }
        return null;
    }

    private boolean betweenJsdocAndCast(AstNode n) {
        int ntype = n.getType();
        return ntype == 33 || ntype == 36 || ntype == 38 || n instanceof Assignment || (ntype == 106 || ntype == 107) && ((UnaryExpression)n).isPostfix();
    }

    private boolean attachToChildren(AstNode n, int napos) {
        int ntype = n.getType();
        if (this.betweenJsdocAndCast(n)) {
            if (!this.attachOnlyToParen) {
                this.attachOnlyToParen = true;
                this.possibleJsdocTarget = n;
                this.possibleApos = napos;
            }
            return true;
        }
        return ntype == 136 || ntype == 102 || ntype == 4 || n instanceof ExpressionStatement || n instanceof InfixExpression;
    }

    private NodePos setJsdoc(AstNode n, int napos) {
        int ntype = n.getType();
        if (this.attachOnlyToParen) {
            this.attachOnlyToParen = false;
            if (ntype != 87) {
                this.possibleJsdocTarget.setJsDocNode(this.currentJsdoc);
                return new NodePos(this.possibleJsdocTarget, this.possibleApos);
            }
        } else {
            switch (ntype) {
                case 50: 
                case 112: 
                case 114: 
                case 115: 
                case 117: 
                case 118: 
                case 119: 
                case 129: {
                    return new NodePos(n, napos);
                }
                case 122: {
                    if (!(n instanceof VariableInitializer)) break;
                    AstNode n2 = ((VariableInitializer)n).getTarget();
                    n2.setJsDocNode(this.currentJsdoc);
                    return new NodePos(n2, napos + n2.getPosition());
                }
            }
        }
        n.setJsDocNode(this.currentJsdoc);
        return new NodePos(n, napos);
    }

    private static class NodePos {
        AstNode n;
        int apos;

        NodePos(AstNode n, int apos) {
            this.n = n;
            this.apos = apos;
        }
    }
}

