/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.rhino.jstype;

import com.google.gwt.thirdparty.javascript.rhino.ErrorReporter;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.gwt.thirdparty.javascript.rhino.jstype.EquivalenceMethod;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.RelationshipVisitor;
import com.google.gwt.thirdparty.javascript.rhino.jstype.StaticScope;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TernaryValue;
import com.google.gwt.thirdparty.javascript.rhino.jstype.Visitor;

final class ArrowType
extends JSType {
    private static final long serialVersionUID = 1L;
    final Node parameters;
    JSType returnType;
    final boolean returnTypeInferred;

    ArrowType(JSTypeRegistry registry, Node parameters, JSType returnType) {
        this(registry, parameters, returnType, false);
    }

    ArrowType(JSTypeRegistry registry, Node parameters, JSType returnType, boolean returnTypeInferred) {
        super(registry);
        this.parameters = parameters == null ? registry.createParametersWithVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE)) : parameters;
        this.returnType = returnType == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : returnType;
        this.returnTypeInferred = returnTypeInferred;
    }

    @Override
    public boolean isSubtype(JSType other) {
        if (!(other instanceof ArrowType)) {
            return false;
        }
        ArrowType that = (ArrowType)other;
        if (!this.returnType.isSubtype(that.returnType)) {
            return false;
        }
        Node thisParam = this.parameters.getFirstChild();
        Node thatParam = that.parameters.getFirstChild();
        while (thisParam != null && thatParam != null) {
            boolean thatIsOptional;
            JSType thisParamType = thisParam.getJSType();
            JSType thatParamType = thatParam.getJSType();
            if (!(thisParamType == null || thatParamType != null && thatParamType.isSubtype(thisParamType))) {
                return false;
            }
            boolean thisIsVarArgs = thisParam.isVarArgs();
            boolean thatIsVarArgs = thatParam.isVarArgs();
            boolean thisIsOptional = thisIsVarArgs || thisParam.isOptionalArg();
            boolean bl = thatIsOptional = thatIsVarArgs || thatParam.isOptionalArg();
            if (!thisIsOptional && thatIsOptional) {
                boolean isTopFunction;
                boolean bl2 = isTopFunction = thatIsVarArgs && (thatParamType == null || thatParamType.isUnknownType() || thatParamType.isNoType());
                if (!isTopFunction) {
                    return false;
                }
            }
            if (!thisIsVarArgs) {
                thisParam = thisParam.getNext();
            }
            if (!thatIsVarArgs) {
                thatParam = thatParam.getNext();
            }
            if (!thisIsVarArgs || !thatIsVarArgs) continue;
            thisParam = null;
            thatParam = null;
        }
        return thisParam == null || thisParam.isOptionalArg() || thisParam.isVarArgs() || thatParam != null;
    }

    boolean hasEqualParameters(ArrowType that, EquivalenceMethod eqMethod) {
        Node otherParam;
        Node thisParam = this.parameters.getFirstChild();
        for (otherParam = that.parameters.getFirstChild(); thisParam != null && otherParam != null; thisParam = thisParam.getNext(), otherParam = otherParam.getNext()) {
            JSType thisParamType = thisParam.getJSType();
            JSType otherParamType = otherParam.getJSType();
            if (thisParamType != null ? otherParamType != null && !thisParamType.checkEquivalenceHelper(otherParamType, eqMethod) : otherParamType != null) {
                return false;
            }
            if (thisParam.isOptionalArg() != otherParam.isOptionalArg()) {
                return false;
            }
            if (thisParam.isVarArgs() == otherParam.isVarArgs()) continue;
            return false;
        }
        return thisParam == otherParam;
    }

    boolean checkArrowEquivalenceHelper(ArrowType that, EquivalenceMethod eqMethod) {
        if (!this.returnType.checkEquivalenceHelper(that.returnType, eqMethod)) {
            return false;
        }
        return this.hasEqualParameters(that, eqMethod);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        if (this.returnType != null) {
            hashCode += this.returnType.hashCode();
        }
        if (this.returnTypeInferred) {
            ++hashCode;
        }
        if (this.parameters != null) {
            for (Node param = this.parameters.getFirstChild(); param != null; param = param.getNext()) {
                JSType paramType = param.getJSType();
                if (paramType == null) continue;
                hashCode += paramType.hashCode();
            }
        }
        return hashCode;
    }

    @Override
    public JSType getLeastSupertype(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JSType getGreatestSubtype(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TernaryValue testForEquality(JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    <T> T visit(RelationshipVisitor<T> visitor, JSType that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanLiteralSet getPossibleToBooleanOutcomes() {
        return BooleanLiteralSet.TRUE;
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticScope<JSType> scope) {
        this.returnType = ArrowType.safeResolve(this.returnType, t, scope);
        if (this.parameters != null) {
            for (Node paramNode = this.parameters.getFirstChild(); paramNode != null; paramNode = paramNode.getNext()) {
                paramNode.setJSType(paramNode.getJSType().resolve(t, scope));
            }
        }
        return this;
    }

    boolean hasUnknownParamsOrReturn() {
        if (this.parameters != null) {
            for (Node paramNode = this.parameters.getFirstChild(); paramNode != null; paramNode = paramNode.getNext()) {
                JSType type = paramNode.getJSType();
                if (type != null && !type.isUnknownType()) continue;
                return true;
            }
        }
        return this.returnType == null || this.returnType.isUnknownType();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        return "[ArrowType]";
    }

    @Override
    public boolean hasAnyTemplateTypesInternal() {
        return this.returnType.hasAnyTemplateTypes() || this.hasTemplatedParameterType();
    }

    private boolean hasTemplatedParameterType() {
        if (this.parameters != null) {
            for (Node paramNode = this.parameters.getFirstChild(); paramNode != null; paramNode = paramNode.getNext()) {
                JSType type = paramNode.getJSType();
                if (type == null || !type.hasAnyTemplateTypes()) continue;
                return true;
            }
        }
        return false;
    }
}

