/*
 * Copyright 2011 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dev.util.log.dashboard;

import com.google.gwt.dev.shell.DevModeSession;

/**
 * Implements the {@code DashboardNotifier} interface but does not actually
 * do anything.
 */
public class NoOpDashboardNotifier implements DashboardNotifier {

  @Override
  public void devModeEventBegin() {
    // do nothing
  }

  @Override
  public void devModeEventEnd(DevModeSession sesion, String eventType, long startTimeNanos,
      long durationNanos) {
    // do nothing
  }

  @Override
  public void devModeSessionBegin(DevModeSession session) {
    // do nothing
  }

  @Override
  public void devModeSessionEnd(DevModeSession session) {
    // do nothing
  }

}
