/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.ui.components.colorpicker;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.shared.ui.colorpicker.Color;
import com.vaadin.v7.ui.ComboBox;
import com.vaadin.v7.ui.components.colorpicker.ColorChangeListener;
import com.vaadin.v7.ui.components.colorpicker.ColorPickerGrid;
import com.vaadin.v7.ui.components.colorpicker.ColorSelector;

@Deprecated
public class ColorPickerSelect
extends CustomComponent
implements ColorSelector,
Property.ValueChangeListener {
    private final ComboBox range;
    private final ColorPickerGrid grid;

    public ColorPickerSelect() {
        VerticalLayout layout = new VerticalLayout();
        this.setCompositionRoot((Component)layout);
        this.setStyleName("colorselect");
        this.setWidth("100%");
        this.range = new ComboBox();
        this.range.setImmediate(true);
        this.range.setImmediate(true);
        this.range.setNullSelectionAllowed(false);
        this.range.setNewItemsAllowed(false);
        this.range.setWidth("100%");
        this.range.addValueChangeListener(this);
        for (ColorRangePropertyId id : ColorRangePropertyId.values()) {
            this.range.addItem((Object)id);
        }
        this.range.select((Object)ColorRangePropertyId.ALL);
        layout.addComponent((Component)this.range);
        this.grid = new ColorPickerGrid(this.createAllColors(14, 10));
        this.grid.setWidth("100%");
        layout.addComponent((Component)this.grid);
    }

    private Color[][] createAllColors(int rows, int columns) {
        Color[][] colors = new Color[rows][columns];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                float value;
                float saturation;
                float hue;
                if (row < rows - 1) {
                    hue = (float)col / (float)columns;
                    saturation = 1.0f;
                    value = 1.0f;
                    if (row < rows / 2) {
                        saturation = ((float)row + 1.0f) / ((float)rows / 2.0f);
                    } else {
                        value = 1.0f - ((float)row - (float)rows / 2.0f) / ((float)rows / 2.0f);
                    }
                    colors[row][col] = new Color(Color.HSVtoRGB((float)hue, (float)saturation, (float)value));
                    continue;
                }
                hue = 0.0f;
                saturation = 0.0f;
                value = 1.0f - (float)col / (float)columns;
                colors[row][col] = new Color(Color.HSVtoRGB((float)hue, (float)saturation, (float)value));
            }
        }
        return colors;
    }

    private Color[][] createColors(Color color, int rows, int columns) {
        Color[][] colors = new Color[rows][columns];
        float[] hsv = color.getHSV();
        float hue = hsv[0];
        float saturation = 1.0f;
        float value = 1.0f;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int index = row * columns + col;
                saturation = 1.0f;
                value = 1.0f;
                if (index <= rows * columns / 2) {
                    saturation = (float)index / ((float)rows * (float)columns / 2.0f);
                } else {
                    value = 1.0f - (float)(index -= rows * columns / 2) / ((float)rows * (float)columns / 2.0f);
                }
                colors[row][col] = new Color(Color.HSVtoRGB((float)hue, (float)saturation, (float)value));
            }
        }
        return colors;
    }

    @Override
    public Color getColor() {
        return this.grid.getColor();
    }

    @Override
    public void setColor(Color color) {
        this.grid.getColor();
    }

    @Override
    public void addColorChangeListener(ColorChangeListener listener) {
        this.grid.addColorChangeListener(listener);
    }

    @Override
    public void removeColorChangeListener(ColorChangeListener listener) {
        this.grid.removeColorChangeListener(listener);
    }

    @Override
    public void valueChange(Property.ValueChangeEvent event) {
        if (this.grid == null) {
            return;
        }
        if (event.getProperty().getValue() == ColorRangePropertyId.ALL) {
            this.grid.setColorGrid(this.createAllColors(14, 10));
        } else if (event.getProperty().getValue() == ColorRangePropertyId.RED) {
            this.grid.setColorGrid(this.createColors(new Color(255, 0, 0), 14, 10));
        } else if (event.getProperty().getValue() == ColorRangePropertyId.GREEN) {
            this.grid.setColorGrid(this.createColors(new Color(0, 255, 0), 14, 10));
        } else if (event.getProperty().getValue() == ColorRangePropertyId.BLUE) {
            this.grid.setColorGrid(this.createColors(new Color(0, 0, 255), 14, 10));
        }
    }

    private static enum ColorRangePropertyId {
        ALL("All colors"),
        RED("Red colors"),
        GREEN("Green colors"),
        BLUE("Blue colors");

        private String caption;

        private ColorRangePropertyId(String caption) {
            this.caption = caption;
        }

        public String toString() {
            return this.caption;
        }
    }
}

