/*
 * Copyright 2011 Vaadin Ltd.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.shared;

public class ApplicationConstants {

    // This indicates the whole page is generated by us (not embedded)
    public static final String GENERATED_BODY_CLASSNAME = "v-generated-body";

    public static final String APP_REQUEST_PATH = "APP";

    public static final String UIDL_REQUEST_PATH = "UIDL/";

    public static final String HEARTBEAT_REQUEST_PATH = "HEARTBEAT/";

    public static final String DEPENDENCY_RESOURCE_PREFIX = APP_REQUEST_PATH
            + '/' + "DEPENDENCY";

    public static final String APP_PROTOCOL_PREFIX = "app://";
    public static final String DEPENDENCY_PROTOCOL_NAME = "dependency";
    public static final String DEPENDENCY_PROTOCOL_PREFIX = DEPENDENCY_PROTOCOL_NAME
            + "://";
    public static final String UIDL_SECURITY_TOKEN_ID = "Vaadin-Security-Key";

    public static final String PARAM_UNLOADBURST = "onunloadburst";

    @Deprecated
    public static final String UPDATE_VARIABLE_INTERFACE = "v";
    @Deprecated
    public static final String UPDATE_VARIABLE_METHOD = "v";

    public static final String SERVICE_URL = "serviceUrl";

    public static final String SERVICE_URL_PATH_AS_PARAMETER = "usePathParameter";

    public static final String V_RESOURCE_PATH = "v-resourcePath";

    @Deprecated
    public static final String DRAG_AND_DROP_CONNECTOR_ID = "DD";

    /**
     * URL parameter used in UIDL requests to indicate that the full server-side
     * state should be returned to the client, i.e. without any incremental
     * changes.
     */
    public static final String URL_PARAMETER_REPAINT_ALL = "repaintAll";

    /**
     * Configuration parameter giving the (in some cases relative) URL to the
     * VAADIN folder from where themes and widgetsets are loaded.
     * <p>
     * <b>Refactor warning:</b> This value is also hardcoded in
     * vaadinBootstrap.js.
     * </p>
     */
    public static final String VAADIN_DIR_URL = "vaadinDir";
}
