/*
 * Copyright 2000-2021 Vaadin Ltd.
 *
 * Licensed under the Commercial Vaadin Developer License version 4.0 (CVDLv4); 
 * you may not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 * https://vaadin.com/license/cvdl-4.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.vaadin.shared.communication;

import java.io.Serializable;

/**
 * Interface to be extended by all server to client RPC interfaces.
 *
 * On the server side, proxies of the interface can be obtained from
 * AbstractComponent. On the client, RPC implementations can be registered with
 * AbstractConnector.registerRpc().
 *
 * Note: Currently, each RPC interface may not contain multiple methods with the
 * same name, even if their parameter lists would differ.
 *
 * @since 7.0
 */
public interface ClientRpc extends Serializable {

}
