/*
 * Decompiled with CFR 0.152.
 */
package com.vericite.client;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DateTimeTypeAdapter
extends TypeAdapter<DateTime> {
    private final DateTimeFormatter formatter = ISODateTimeFormat.dateTime();

    DateTimeTypeAdapter() {
    }

    public void write(JsonWriter out, DateTime date) throws IOException {
        if (date == null) {
            out.nullValue();
        } else {
            out.value(this.formatter.print((ReadableInstant)date));
        }
    }

    public DateTime read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        String date = in.nextString();
        return this.formatter.parseDateTime(date);
    }
}

