/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.yammer.metrics.health.HealthCheck;
import com.yammer.metrics.json.MetricsModule;
import java.io.IOException;
import java.util.Arrays;

public class HealthCheckModule
extends Module {
    public String getModuleName() {
        return "healthchecks";
    }

    public Version version() {
        return MetricsModule.VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new SimpleSerializers(Arrays.asList(new JsonSerializer[]{new HealthCheckResultSerializer()})));
    }

    private static class HealthCheckResultSerializer
    extends StdSerializer<HealthCheck.Result> {
        private HealthCheckResultSerializer() {
            super(HealthCheck.Result.class);
        }

        public void serialize(HealthCheck.Result result, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeBooleanField("healthy", result.isHealthy());
            String message = result.getMessage();
            if (message != null) {
                json.writeStringField("message", message);
            }
            this.serializeThrowable(json, result.getError(), "error");
            json.writeEndObject();
        }

        private void serializeThrowable(JsonGenerator json, Throwable error, String name) throws IOException {
            if (error != null) {
                json.writeObjectFieldStart(name);
                json.writeStringField("message", error.getMessage());
                json.writeArrayFieldStart("stack");
                for (StackTraceElement element : error.getStackTrace()) {
                    json.writeString(element.toString());
                }
                json.writeEndArray();
                if (error.getCause() != null) {
                    this.serializeThrowable(json, error.getCause(), "cause");
                }
                json.writeEndObject();
            }
        }
    }
}

