/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.internal.util;

import COSE.CoseException;
import COSE.OneKey;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.upokecenter.cbor.CBORObject;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;

public final class WebAuthnCodecs {
    public static ObjectMapper cbor() {
        return new ObjectMapper((JsonFactory)new CBORFactory()).setBase64Variant(Base64Variants.MODIFIED_FOR_URL);
    }

    public static ObjectMapper json() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).setBase64Variant(Base64Variants.MODIFIED_FOR_URL).registerModule((Module)new Jdk8Module());
    }

    public static CBORObject deepCopy(CBORObject a) {
        return CBORObject.DecodeFromBytes((byte[])a.EncodeToBytes());
    }

    public static ObjectNode deepCopy(ObjectNode a) {
        try {
            return (ObjectNode)WebAuthnCodecs.json().readTree(WebAuthnCodecs.json().writeValueAsString((Object)a));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteArray ecPublicKeyToRaw(ECPublicKey key) {
        byte[] x = key.getW().getAffineX().toByteArray();
        byte[] y = key.getW().getAffineY().toByteArray();
        byte[] xPadding = new byte[Math.max(0, 32 - x.length)];
        byte[] yPadding = new byte[Math.max(0, 32 - y.length)];
        java.util.Arrays.fill(xPadding, (byte)0);
        java.util.Arrays.fill(yPadding, (byte)0);
        return new ByteArray(Arrays.concatenate((byte[])new byte[]{4}, (byte[])Arrays.concatenate((byte[])xPadding, (byte[])java.util.Arrays.copyOfRange(x, Math.max(0, x.length - 32), x.length)), (byte[])Arrays.concatenate((byte[])yPadding, (byte[])java.util.Arrays.copyOfRange(y, Math.max(0, y.length - 32), y.length))));
    }

    public static ByteArray rawEcdaKeyToCose(ByteArray key) {
        byte[] keyBytes = key.getBytes();
        if (keyBytes.length != 64 && (keyBytes.length != 65 || keyBytes[0] != 4)) {
            throw new IllegalArgumentException(String.format("Raw key must be 64 bytes long or be 65 bytes long and start with 0x04, was %d bytes starting with %02x", keyBytes.length, keyBytes[0]));
        }
        int start = keyBytes.length == 64 ? 0 : 1;
        HashMap<Long, Object> coseKey = new HashMap<Long, Object>();
        coseKey.put(1L, 2L);
        coseKey.put(3L, COSEAlgorithmIdentifier.ES256.getId());
        coseKey.put(-1L, 1L);
        coseKey.put(-2L, java.util.Arrays.copyOfRange(keyBytes, start, start + 32));
        coseKey.put(-3L, java.util.Arrays.copyOfRange(keyBytes, start + 32, start + 64));
        return new ByteArray(CBORObject.FromObject(coseKey).EncodeToBytes());
    }

    public static ByteArray ecPublicKeyToCose(ECPublicKey key) {
        return WebAuthnCodecs.rawEcdaKeyToCose(WebAuthnCodecs.ecPublicKeyToRaw(key));
    }

    public static PublicKey importCosePublicKey(ByteArray key) throws CoseException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        CBORObject cose = CBORObject.DecodeFromBytes((byte[])key.getBytes());
        int kty = cose.get(CBORObject.FromObject((int)1)).AsInt32();
        switch (kty) {
            case 2: {
                return WebAuthnCodecs.importCoseP256PublicKey(cose);
            }
            case 3: {
                return WebAuthnCodecs.importCoseRsaPublicKey(cose);
            }
        }
        throw new IllegalArgumentException("Unsupported key type: " + kty);
    }

    private static PublicKey importCoseRsaPublicKey(CBORObject cose) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, cose.get(CBORObject.FromObject((int)-1)).GetByteString()), new BigInteger(1, cose.get(CBORObject.FromObject((int)-2)).GetByteString()));
        return KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider()).generatePublic(spec);
    }

    private static ECPublicKey importCoseP256PublicKey(CBORObject cose) throws CoseException, IOException {
        return new COSE.ECPublicKey(new OneKey(cose));
    }

    public static String getSignatureAlgorithmName(PublicKey key) {
        if (key.getAlgorithm().equals("EC")) {
            return "ECDSA";
        }
        return key.getAlgorithm();
    }

    public static String jwsAlgorithmNameToJavaAlgorithmName(String alg) {
        switch (alg) {
            case "RS256": {
                return "SHA256withRSA";
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + alg);
    }
}

