/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.attestation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.attestation.Transport;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import lombok.NonNull;

public final class Attestation
implements Serializable {
    private final boolean trusted;
    @NonNull
    private final Optional<String> metadataIdentifier;
    @NonNull
    private final Optional<Map<String, String>> vendorProperties;
    @NonNull
    private final Optional<Map<String, String>> deviceProperties;
    @NonNull
    private final Optional<Set<Transport>> transports;

    @JsonCreator
    private Attestation(@JsonProperty(value="trusted") boolean trusted, @JsonProperty(value="metadataIdentifier") @NonNull Optional<String> metadataIdentifier, @JsonProperty(value="vendorProperties") @NonNull Optional<Map<String, String>> vendorProperties, @JsonProperty(value="deviceProperties") @NonNull Optional<Map<String, String>> deviceProperties, @JsonProperty(value="transports") @NonNull Optional<Set<Transport>> transports) {
        if (metadataIdentifier == null) {
            throw new NullPointerException("metadataIdentifier is marked @NonNull but is null");
        }
        if (vendorProperties == null) {
            throw new NullPointerException("vendorProperties is marked @NonNull but is null");
        }
        if (deviceProperties == null) {
            throw new NullPointerException("deviceProperties is marked @NonNull but is null");
        }
        if (transports == null) {
            throw new NullPointerException("transports is marked @NonNull but is null");
        }
        this.trusted = trusted;
        this.metadataIdentifier = metadataIdentifier;
        this.vendorProperties = vendorProperties;
        this.deviceProperties = deviceProperties;
        this.transports = transports.map(TreeSet::new);
    }

    public static Attestation empty() {
        return Attestation.builder().trusted(false).build();
    }

    public static AttestationBuilder.MandatoryStages builder() {
        return new AttestationBuilder.MandatoryStages();
    }

    @Generated
    private static Optional<String> $default$metadataIdentifier() {
        return Optional.empty();
    }

    @Generated
    private static Optional<Map<String, String>> $default$vendorProperties() {
        return Optional.empty();
    }

    @Generated
    private static Optional<Map<String, String>> $default$deviceProperties() {
        return Optional.empty();
    }

    @Generated
    private static Optional<Set<Transport>> $default$transports() {
        return Optional.empty();
    }

    @Generated
    public AttestationBuilder toBuilder() {
        return new AttestationBuilder().trusted(this.trusted).metadataIdentifier(this.metadataIdentifier).vendorProperties(this.vendorProperties).deviceProperties(this.deviceProperties).transports(this.transports);
    }

    @Generated
    public boolean isTrusted() {
        return this.trusted;
    }

    @NonNull
    @Generated
    public Optional<String> getMetadataIdentifier() {
        return this.metadataIdentifier;
    }

    @NonNull
    @Generated
    public Optional<Map<String, String>> getVendorProperties() {
        return this.vendorProperties;
    }

    @NonNull
    @Generated
    public Optional<Map<String, String>> getDeviceProperties() {
        return this.deviceProperties;
    }

    @NonNull
    @Generated
    public Optional<Set<Transport>> getTransports() {
        return this.transports;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attestation)) {
            return false;
        }
        Attestation other = (Attestation)o;
        if (this.isTrusted() != other.isTrusted()) {
            return false;
        }
        Optional<String> this$metadataIdentifier = this.getMetadataIdentifier();
        Optional<String> other$metadataIdentifier = other.getMetadataIdentifier();
        if (this$metadataIdentifier == null ? other$metadataIdentifier != null : !((Object)this$metadataIdentifier).equals(other$metadataIdentifier)) {
            return false;
        }
        Optional<Map<String, String>> this$vendorProperties = this.getVendorProperties();
        Optional<Map<String, String>> other$vendorProperties = other.getVendorProperties();
        if (this$vendorProperties == null ? other$vendorProperties != null : !((Object)this$vendorProperties).equals(other$vendorProperties)) {
            return false;
        }
        Optional<Map<String, String>> this$deviceProperties = this.getDeviceProperties();
        Optional<Map<String, String>> other$deviceProperties = other.getDeviceProperties();
        if (this$deviceProperties == null ? other$deviceProperties != null : !((Object)this$deviceProperties).equals(other$deviceProperties)) {
            return false;
        }
        Optional<Set<Transport>> this$transports = this.getTransports();
        Optional<Set<Transport>> other$transports = other.getTransports();
        return !(this$transports == null ? other$transports != null : !((Object)this$transports).equals(other$transports));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrusted() ? 79 : 97);
        Optional<String> $metadataIdentifier = this.getMetadataIdentifier();
        result = result * 59 + ($metadataIdentifier == null ? 43 : ((Object)$metadataIdentifier).hashCode());
        Optional<Map<String, String>> $vendorProperties = this.getVendorProperties();
        result = result * 59 + ($vendorProperties == null ? 43 : ((Object)$vendorProperties).hashCode());
        Optional<Map<String, String>> $deviceProperties = this.getDeviceProperties();
        result = result * 59 + ($deviceProperties == null ? 43 : ((Object)$deviceProperties).hashCode());
        Optional<Set<Transport>> $transports = this.getTransports();
        result = result * 59 + ($transports == null ? 43 : ((Object)$transports).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Attestation(trusted=" + this.isTrusted() + ", metadataIdentifier=" + this.getMetadataIdentifier() + ", vendorProperties=" + this.getVendorProperties() + ", deviceProperties=" + this.getDeviceProperties() + ", transports=" + this.getTransports() + ")";
    }

    public static class AttestationBuilder {
        @Generated
        private boolean trusted;
        @Generated
        private boolean metadataIdentifier$set;
        @Generated
        private Optional<String> metadataIdentifier;
        @Generated
        private boolean vendorProperties$set;
        @Generated
        private Optional<Map<String, String>> vendorProperties;
        @Generated
        private boolean deviceProperties$set;
        @Generated
        private Optional<Map<String, String>> deviceProperties;
        @Generated
        private boolean transports$set;
        @Generated
        private Optional<Set<Transport>> transports;

        @Generated
        AttestationBuilder() {
        }

        @Generated
        public AttestationBuilder trusted(boolean trusted) {
            this.trusted = trusted;
            return this;
        }

        @Generated
        public AttestationBuilder metadataIdentifier(@NonNull Optional<String> metadataIdentifier) {
            if (metadataIdentifier == null) {
                throw new NullPointerException("metadataIdentifier is marked @NonNull but is null");
            }
            this.metadataIdentifier = metadataIdentifier;
            this.metadataIdentifier$set = true;
            return this;
        }

        @Generated
        public AttestationBuilder vendorProperties(@NonNull Optional<Map<String, String>> vendorProperties) {
            if (vendorProperties == null) {
                throw new NullPointerException("vendorProperties is marked @NonNull but is null");
            }
            this.vendorProperties = vendorProperties;
            this.vendorProperties$set = true;
            return this;
        }

        @Generated
        public AttestationBuilder deviceProperties(@NonNull Optional<Map<String, String>> deviceProperties) {
            if (deviceProperties == null) {
                throw new NullPointerException("deviceProperties is marked @NonNull but is null");
            }
            this.deviceProperties = deviceProperties;
            this.deviceProperties$set = true;
            return this;
        }

        @Generated
        public AttestationBuilder transports(@NonNull Optional<Set<Transport>> transports) {
            if (transports == null) {
                throw new NullPointerException("transports is marked @NonNull but is null");
            }
            this.transports = transports;
            this.transports$set = true;
            return this;
        }

        @Generated
        public Attestation build() {
            Optional metadataIdentifier = this.metadataIdentifier;
            if (!this.metadataIdentifier$set) {
                metadataIdentifier = Attestation.$default$metadataIdentifier();
            }
            Optional vendorProperties = this.vendorProperties;
            if (!this.vendorProperties$set) {
                vendorProperties = Attestation.$default$vendorProperties();
            }
            Optional deviceProperties = this.deviceProperties;
            if (!this.deviceProperties$set) {
                deviceProperties = Attestation.$default$deviceProperties();
            }
            Optional transports = this.transports;
            if (!this.transports$set) {
                transports = Attestation.$default$transports();
            }
            return new Attestation(this.trusted, metadataIdentifier, vendorProperties, deviceProperties, transports);
        }

        @Generated
        public String toString() {
            return "Attestation.AttestationBuilder(trusted=" + this.trusted + ", metadataIdentifier=" + this.metadataIdentifier + ", vendorProperties=" + this.vendorProperties + ", deviceProperties=" + this.deviceProperties + ", transports=" + this.transports + ")";
        }

        public static class MandatoryStages {
            private final AttestationBuilder builder = new AttestationBuilder();

            public AttestationBuilder trusted(boolean trusted) {
                return this.builder.trusted(trusted);
            }
        }
    }
}

