/*
 * Decompiled with CFR 0.152.
 */
package com.yungouos.pay.order;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.yungouos.pay.common.PayException;
import com.yungouos.pay.config.OrderApiConfig;
import com.yungouos.pay.entity.PayOrder;
import com.yungouos.pay.util.PaySignUtil;
import java.util.HashMap;

public class SystemOrder {
    public static PayOrder getOrderInfoByOutTradeNo(String out_trade_no, String mch_id, String key) throws PayException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        PayOrder payOrder = null;
        try {
            if (StrUtil.isBlank(out_trade_no)) {
                throw new PayException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(mch_id)) {
                throw new PayException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank(key)) {
                throw new PayException("\u5546\u6237\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            params.put("out_trade_no", out_trade_no);
            params.put("mch_id", mch_id);
            String sign = PaySignUtil.createSign(params, key);
            params.put("sign", sign);
            String result = HttpRequest.get(OrderApiConfig.getOrderUrl).form(params).execute().body();
            if (StrUtil.isBlank(result)) {
                throw new PayException("API\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            JSONObject jsonObject = (JSONObject)JSONObject.parse(result);
            if (jsonObject == null) {
                throw new PayException("API\u7ed3\u679c\u8f6c\u6362\u9519\u8bef");
            }
            Integer code = jsonObject.getInteger("code");
            if (0 != code) {
                throw new PayException(jsonObject.getString("msg"));
            }
            JSONObject json = jsonObject.getJSONObject("data");
            if (json == null) {
                throw new PayException("API\u7ed3\u679c\u6570\u636e\u8f6c\u6362\u9519\u8bef");
            }
            payOrder = JSONObject.toJavaObject(json, PayOrder.class);
        }
        catch (PayException e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PayException(e.getMessage());
        }
        return payOrder;
    }
}

