/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.threads;

import java.util.Map;
import org.apache.avalon.cornerstone.blocks.threads.AbstractThreadManager;
import org.apache.avalon.excalibur.thread.impl.DefaultThreadPool;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class DefaultThreadManager
extends AbstractThreadManager {
    protected void configureThreadPool(Map threadPools, Configuration configuration) throws ConfigurationException {
        String name = configuration.getChild("name").getValue();
        boolean isDaemon = configuration.getChild("is-daemon").getValueAsBoolean(false);
        int minThreads = configuration.getChild("min-threads").getValueAsInteger(5);
        int maxThreads = configuration.getChild("max-threads").getValueAsInteger(10);
        try {
            DefaultThreadPool threadPool = new DefaultThreadPool(name, minThreads, maxThreads);
            threadPool.setDaemon(isDaemon);
            threadPool.enableLogging(this.getLogger());
            threadPools.put(name, threadPool);
        }
        catch (Exception e) {
            String message = "Error creating ThreadPool named " + name;
            throw new ConfigurationException(message, (Throwable)e);
        }
    }
}

