/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.daogenerator;

import de.greenrobot.daogenerator.DaoUtil;
import de.greenrobot.daogenerator.Entity;
import de.greenrobot.daogenerator.Schema;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DaoGenerator {
    private Pattern patternKeepIncludes;
    private Pattern patternKeepFields;
    private Pattern patternKeepMethods;
    private Template templateDao;
    private Template templateDaoMaster;
    private Template templateDaoSession;
    private Template templateEntity;
    private Template templateDaoUnitTest;

    public DaoGenerator() throws IOException {
        System.out.println("greenDAO Generator");
        System.out.println("Copyright 2011-2013 Markus Junginger, greenrobot.de. Licensed under GPL V3.");
        System.out.println("This program comes with ABSOLUTELY NO WARRANTY");
        this.patternKeepIncludes = this.compilePattern("INCLUDES");
        this.patternKeepFields = this.compilePattern("FIELDS");
        this.patternKeepMethods = this.compilePattern("METHODS");
        Configuration config = new Configuration();
        config.setClassForTemplateLoading(this.getClass(), "/");
        config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.templateDao = config.getTemplate("dao.ftl");
        this.templateDaoMaster = config.getTemplate("dao-master.ftl");
        this.templateDaoSession = config.getTemplate("dao-session.ftl");
        this.templateEntity = config.getTemplate("entity.ftl");
        this.templateDaoUnitTest = config.getTemplate("dao-unit-test.ftl");
    }

    private Pattern compilePattern(String sectionName) {
        int flags = 40;
        return Pattern.compile(".*^\\s*?//\\s*?KEEP " + sectionName + ".*?\n(.*?)^\\s*// KEEP " + sectionName + " END.*?\n", flags);
    }

    public void generateAll(Schema schema, String outDir) throws Exception {
        this.generateAll(schema, outDir, null);
    }

    public void generateAll(Schema schema, String outDir, String outDirTest) throws Exception {
        long start = System.currentTimeMillis();
        File outDirFile = this.toFileForceExists(outDir);
        File outDirTestFile = null;
        if (outDirTest != null) {
            outDirTestFile = this.toFileForceExists(outDirTest);
        }
        schema.init2ndPass();
        schema.init3ndPass();
        System.out.println("Processing schema version " + schema.getVersion() + "...");
        List<Entity> entities = schema.getEntities();
        for (Entity entity : entities) {
            String classNameTest;
            this.generate(this.templateDao, outDirFile, entity.getJavaPackageDao(), entity.getClassNameDao(), schema, entity);
            if (!entity.isProtobuf() && !entity.isSkipGeneration()) {
                this.generate(this.templateEntity, outDirFile, entity.getJavaPackage(), entity.getClassName(), schema, entity);
            }
            if (outDirTestFile == null || entity.isSkipGenerationTest()) continue;
            String javaPackageTest = entity.getJavaPackageTest();
            File javaFilename = this.toJavaFilename(outDirTestFile, javaPackageTest, classNameTest = entity.getClassNameTest());
            if (!javaFilename.exists()) {
                this.generate(this.templateDaoUnitTest, outDirTestFile, javaPackageTest, classNameTest, schema, entity);
                continue;
            }
            System.out.println("Skipped " + javaFilename.getCanonicalPath());
        }
        this.generate(this.templateDaoMaster, outDirFile, schema.getDefaultJavaPackageDao(), "DaoMaster", schema, null);
        this.generate(this.templateDaoSession, outDirFile, schema.getDefaultJavaPackageDao(), "DaoSession", schema, null);
        long time = System.currentTimeMillis() - start;
        System.out.println("Processed " + entities.size() + " entities in " + time + "ms");
    }

    protected File toFileForceExists(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException(filename + " does not exist. This check is to prevent accidential file generation into a wrong path.");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(Template template, File outDirFile, String javaPackage, String javaClassName, Schema schema, Entity entity) throws Exception {
        try {
            File file = this.toJavaFilename(outDirFile, javaPackage, javaClassName);
            file.getParentFile().mkdirs();
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("schema", schema);
            root.put("entity", entity);
            if (entity != null && entity.getHasKeepSections().booleanValue()) {
                this.checkKeepSections(file, root);
            }
            FileWriter writer = new FileWriter(file);
            try {
                template.process(root, (Writer)writer);
                ((Writer)writer).flush();
                System.out.println("Written " + file.getCanonicalPath());
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (Exception ex) {
            System.err.println("Error while generating " + javaPackage + "." + javaClassName + " (" + outDirFile.getCanonicalPath() + ")");
            throw ex;
        }
    }

    private void checkKeepSections(File file, Map<String, Object> root) {
        if (file.exists()) {
            try {
                String contents = new String(DaoUtil.readAllBytes(file));
                Matcher matcher = this.patternKeepIncludes.matcher(contents);
                if (matcher.matches()) {
                    root.put("keepIncludes", matcher.group(1));
                }
                if ((matcher = this.patternKeepFields.matcher(contents)).matches()) {
                    root.put("keepFields", matcher.group(1));
                }
                if ((matcher = this.patternKeepMethods.matcher(contents)).matches()) {
                    root.put("keepMethods", matcher.group(1));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected File toJavaFilename(File outDirFile, String javaPackage, String javaClassName) {
        String packageSubPath = javaPackage.replace('.', '/');
        File packagePath = new File(outDirFile, packageSubPath);
        File file = new File(packagePath, javaClassName + ".java");
        return file;
    }
}

