/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.daogenerator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DaoUtil {
    public static String dbName(String javaName) {
        StringBuilder builder = new StringBuilder(javaName);
        for (int i = 1; i < builder.length(); ++i) {
            boolean lastWasUpper = Character.isUpperCase(builder.charAt(i - 1));
            boolean isUpper = Character.isUpperCase(builder.charAt(i));
            if (!isUpper || lastWasUpper) continue;
            builder.insert(i, '_');
            ++i;
        }
        return builder.toString().toUpperCase();
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DaoUtil.copyAllBytes(in, out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] byArray = DaoUtil.readAllBytes(is);
            return byArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(String filename) throws IOException {
        FileInputStream is = new FileInputStream(filename);
        try {
            byte[] byArray = DaoUtil.readAllBytes(is);
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static int copyAllBytes(InputStream in, OutputStream out) throws IOException {
        int read;
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            byteCount += read;
        }
        return byteCount;
    }
}

