/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.daogenerator;

import de.greenrobot.daogenerator.DaoUtil;
import de.greenrobot.daogenerator.Index;
import de.greenrobot.daogenerator.Property;
import de.greenrobot.daogenerator.PropertyType;
import de.greenrobot.daogenerator.Schema;
import de.greenrobot.daogenerator.ToMany;
import de.greenrobot.daogenerator.ToOne;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Entity {
    private final Schema schema;
    private final String className;
    private final List<Property> properties;
    private List<Property> propertiesColumns;
    private final List<Property> propertiesPk;
    private final List<Property> propertiesNonPk;
    private final Set<String> propertyNames;
    private final List<Index> indexes;
    private final List<ToOne> toOneRelations;
    private final List<ToMany> toManyRelations;
    private final List<ToMany> incomingToManyRelations;
    private final Collection<String> additionalImportsEntity;
    private final Collection<String> additionalImportsDao;
    private final List<String> interfacesToImplement;
    private String tableName;
    private String classNameDao;
    private String classNameTest;
    private String javaPackage;
    private String javaPackageDao;
    private String javaPackageTest;
    private Property pkProperty;
    private String pkType;
    private String superclass;
    private boolean protobuf;
    private boolean constructors;
    private boolean skipGeneration;
    private boolean skipGenerationTest;
    private boolean skipTableCreation;
    private Boolean active;
    private Boolean hasKeepSections;

    Entity(Schema schema, String className) {
        this.schema = schema;
        this.className = className;
        this.properties = new ArrayList<Property>();
        this.propertiesPk = new ArrayList<Property>();
        this.propertiesNonPk = new ArrayList<Property>();
        this.propertyNames = new HashSet<String>();
        this.indexes = new ArrayList<Index>();
        this.toOneRelations = new ArrayList<ToOne>();
        this.toManyRelations = new ArrayList<ToMany>();
        this.incomingToManyRelations = new ArrayList<ToMany>();
        this.additionalImportsEntity = new TreeSet<String>();
        this.additionalImportsDao = new TreeSet<String>();
        this.interfacesToImplement = new ArrayList<String>();
        this.constructors = true;
    }

    public Property.PropertyBuilder addBooleanProperty(String propertyName) {
        return this.addProperty(PropertyType.Boolean, propertyName);
    }

    public Property.PropertyBuilder addByteProperty(String propertyName) {
        return this.addProperty(PropertyType.Byte, propertyName);
    }

    public Property.PropertyBuilder addShortProperty(String propertyName) {
        return this.addProperty(PropertyType.Short, propertyName);
    }

    public Property.PropertyBuilder addIntProperty(String propertyName) {
        return this.addProperty(PropertyType.Int, propertyName);
    }

    public Property.PropertyBuilder addLongProperty(String propertyName) {
        return this.addProperty(PropertyType.Long, propertyName);
    }

    public Property.PropertyBuilder addFloatProperty(String propertyName) {
        return this.addProperty(PropertyType.Float, propertyName);
    }

    public Property.PropertyBuilder addDoubleProperty(String propertyName) {
        return this.addProperty(PropertyType.Double, propertyName);
    }

    public Property.PropertyBuilder addByteArrayProperty(String propertyName) {
        return this.addProperty(PropertyType.ByteArray, propertyName);
    }

    public Property.PropertyBuilder addStringProperty(String propertyName) {
        return this.addProperty(PropertyType.String, propertyName);
    }

    public Property.PropertyBuilder addDateProperty(String propertyName) {
        return this.addProperty(PropertyType.Date, propertyName);
    }

    public Property.PropertyBuilder addProperty(PropertyType propertyType, String propertyName) {
        if (!this.propertyNames.add(propertyName)) {
            throw new RuntimeException("Property already defined: " + propertyName);
        }
        Property.PropertyBuilder builder = new Property.PropertyBuilder(this.schema, this, propertyType, propertyName);
        this.properties.add(builder.getProperty());
        return builder;
    }

    public Property.PropertyBuilder addIdProperty() {
        Property.PropertyBuilder builder = this.addLongProperty("id");
        builder.columnName("_id").primaryKey();
        return builder;
    }

    public ToMany addToMany(Entity target, Property targetProperty) {
        Property[] targetProperties = new Property[]{targetProperty};
        return this.addToMany(null, target, targetProperties);
    }

    public ToMany addToMany(Entity target, Property targetProperty, String name) {
        ToMany toMany = this.addToMany(target, targetProperty);
        toMany.setName(name);
        return toMany;
    }

    public ToMany addToMany(Property sourceProperty, Entity target, Property targetProperty) {
        Property[] sourceProperties = new Property[]{sourceProperty};
        Property[] targetProperties = new Property[]{targetProperty};
        return this.addToMany(sourceProperties, target, targetProperties);
    }

    public ToMany addToMany(Property[] sourceProperties, Entity target, Property[] targetProperties) {
        if (this.protobuf) {
            throw new IllegalStateException("Protobuf entities do not support realtions, currently");
        }
        ToMany toMany = new ToMany(this.schema, this, sourceProperties, target, targetProperties);
        this.toManyRelations.add(toMany);
        target.incomingToManyRelations.add(toMany);
        return toMany;
    }

    public ToOne addToOne(Entity target, Property fkProperty) {
        if (this.protobuf) {
            throw new IllegalStateException("Protobuf entities do not support realtions, currently");
        }
        Property[] fkProperties = new Property[]{fkProperty};
        ToOne toOne = new ToOne(this.schema, this, target, fkProperties, true);
        this.toOneRelations.add(toOne);
        return toOne;
    }

    public ToOne addToOne(Entity target, Property fkProperty, String name) {
        ToOne toOne = this.addToOne(target, fkProperty);
        toOne.setName(name);
        return toOne;
    }

    public ToOne addToOneWithoutProperty(String name, Entity target, String fkColumnName) {
        return this.addToOneWithoutProperty(name, target, fkColumnName, false, false);
    }

    public ToOne addToOneWithoutProperty(String name, Entity target, String fkColumnName, boolean notNull, boolean unique) {
        Property.PropertyBuilder propertyBuilder = new Property.PropertyBuilder(this.schema, this, null, name);
        if (notNull) {
            propertyBuilder.notNull();
        }
        if (unique) {
            propertyBuilder.unique();
        }
        propertyBuilder.columnName(fkColumnName);
        Property column = propertyBuilder.getProperty();
        Property[] fkColumns = new Property[]{column};
        ToOne toOne = new ToOne(this.schema, this, target, fkColumns, false);
        toOne.setName(name);
        this.toOneRelations.add(toOne);
        return toOne;
    }

    protected void addIncomingToMany(ToMany toMany) {
        this.incomingToManyRelations.add(toMany);
    }

    public Entity addIndex(Index index) {
        this.indexes.add(index);
        return this;
    }

    Entity useProtobuf() {
        this.protobuf = true;
        return this;
    }

    public boolean isProtobuf() {
        return this.protobuf;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getClassName() {
        return this.className;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Property> getPropertiesColumns() {
        return this.propertiesColumns;
    }

    public String getJavaPackage() {
        return this.javaPackage;
    }

    public void setJavaPackage(String javaPackage) {
        this.javaPackage = javaPackage;
    }

    public String getJavaPackageDao() {
        return this.javaPackageDao;
    }

    public void setJavaPackageDao(String javaPackageDao) {
        this.javaPackageDao = javaPackageDao;
    }

    public String getClassNameDao() {
        return this.classNameDao;
    }

    public void setClassNameDao(String classNameDao) {
        this.classNameDao = classNameDao;
    }

    public String getClassNameTest() {
        return this.classNameTest;
    }

    public void setClassNameTest(String classNameTest) {
        this.classNameTest = classNameTest;
    }

    public String getJavaPackageTest() {
        return this.javaPackageTest;
    }

    public void setJavaPackageTest(String javaPackageTest) {
        this.javaPackageTest = javaPackageTest;
    }

    public List<Property> getPropertiesPk() {
        return this.propertiesPk;
    }

    public List<Property> getPropertiesNonPk() {
        return this.propertiesNonPk;
    }

    public Property getPkProperty() {
        return this.pkProperty;
    }

    public List<Index> getIndexes() {
        return this.indexes;
    }

    public String getPkType() {
        return this.pkType;
    }

    public boolean isConstructors() {
        return this.constructors;
    }

    public void setConstructors(boolean constructors) {
        this.constructors = constructors;
    }

    public boolean isSkipGeneration() {
        return this.skipGeneration;
    }

    public void setSkipGeneration(boolean skipGeneration) {
        this.skipGeneration = skipGeneration;
    }

    public void setSkipTableCreation(boolean skipTableCreation) {
        this.skipTableCreation = skipTableCreation;
    }

    public boolean isSkipTableCreation() {
        return this.skipTableCreation;
    }

    public boolean isSkipGenerationTest() {
        return this.skipGenerationTest;
    }

    public void setSkipGenerationTest(boolean skipGenerationTest) {
        this.skipGenerationTest = skipGenerationTest;
    }

    public List<ToOne> getToOneRelations() {
        return this.toOneRelations;
    }

    public List<ToMany> getToManyRelations() {
        return this.toManyRelations;
    }

    public List<ToMany> getIncomingToManyRelations() {
        return this.incomingToManyRelations;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getHasKeepSections() {
        return this.hasKeepSections;
    }

    public Collection<String> getAdditionalImportsEntity() {
        return this.additionalImportsEntity;
    }

    public Collection<String> getAdditionalImportsDao() {
        return this.additionalImportsDao;
    }

    public void setHasKeepSections(Boolean hasKeepSections) {
        this.hasKeepSections = hasKeepSections;
    }

    public List<String> getInterfacesToImplement() {
        return this.interfacesToImplement;
    }

    public void implementsInterface(String ... interfaces) {
        for (String interfaceToImplement : interfaces) {
            this.interfacesToImplement.add(interfaceToImplement);
        }
    }

    public void implementsSerializable() {
        this.interfacesToImplement.add("java.io.Serializable");
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(String classToExtend) {
        this.superclass = classToExtend;
    }

    void init2ndPass() {
        this.init2nPassNamesWithDefaults();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = this.properties.get(i);
            property.setOrdinal(i);
            property.init2ndPass();
            if (property.isPrimaryKey()) {
                this.propertiesPk.add(property);
                continue;
            }
            this.propertiesNonPk.add(property);
        }
        if (this.propertiesPk.size() == 1) {
            this.pkProperty = this.propertiesPk.get(0);
            this.pkType = this.schema.mapToJavaTypeNullable(this.pkProperty.getPropertyType());
        } else {
            this.pkType = "Void";
        }
        this.propertiesColumns = new ArrayList<Property>(this.properties);
        for (ToOne toOne : this.toOneRelations) {
            Property[] fkProperties;
            toOne.init2ndPass();
            for (Property fkProperty : fkProperties = toOne.getFkProperties()) {
                if (this.propertiesColumns.contains(fkProperty)) continue;
                this.propertiesColumns.add(fkProperty);
            }
        }
        for (ToMany toMany : this.toManyRelations) {
            toMany.init2ndPass();
        }
        if (this.active == null) {
            this.active = this.schema.isUseActiveEntitiesByDefault();
        }
        this.active = this.active | (!this.toOneRelations.isEmpty() || !this.toManyRelations.isEmpty());
        if (this.hasKeepSections == null) {
            this.hasKeepSections = this.schema.isHasKeepSectionsByDefault();
        }
        this.init2ndPassIndexNamesWithDefaults();
    }

    protected void init2nPassNamesWithDefaults() {
        if (this.tableName == null) {
            this.tableName = DaoUtil.dbName(this.className);
        }
        if (this.classNameDao == null) {
            this.classNameDao = this.className + "Dao";
        }
        if (this.classNameTest == null) {
            this.classNameTest = this.className + "Test";
        }
        if (this.javaPackage == null) {
            this.javaPackage = this.schema.getDefaultJavaPackage();
        }
        if (this.javaPackageDao == null) {
            this.javaPackageDao = this.schema.getDefaultJavaPackageDao();
            if (this.javaPackageDao == null) {
                this.javaPackageDao = this.javaPackage;
            }
        }
        if (this.javaPackageTest == null) {
            this.javaPackageTest = this.schema.getDefaultJavaPackageTest();
            if (this.javaPackageTest == null) {
                this.javaPackageTest = this.javaPackage;
            }
        }
    }

    protected void init2ndPassIndexNamesWithDefaults() {
        for (int i = 0; i < this.indexes.size(); ++i) {
            Index index = this.indexes.get(i);
            if (index.getName() != null) continue;
            String indexName = "IDX_" + this.getTableName();
            List<Property> properties = index.getProperties();
            for (int j = 0; j < properties.size(); ++j) {
                Property property = properties.get(j);
                indexName = indexName + "_" + property.getColumnName();
                if (!"DESC".equalsIgnoreCase(index.getPropertiesOrder().get(j))) continue;
                indexName = indexName + "_DESC";
            }
            index.setName(indexName);
        }
    }

    void init3ndPass() {
        for (Property property : this.properties) {
            property.init3ndPass();
        }
        this.init3rdPassRelations();
        this.init3rdPassAdditionalImports();
    }

    private void init3rdPassRelations() {
        HashSet<String> toOneNames = new HashSet<String>();
        for (ToOne toOne : this.toOneRelations) {
            toOne.init3ndPass();
            if (toOneNames.add(toOne.getName().toLowerCase())) continue;
            throw new RuntimeException("Duplicate name for " + toOne);
        }
        HashSet<String> toManyNames = new HashSet<String>();
        for (ToMany toMany : this.toManyRelations) {
            toMany.init3ndPass();
            Entity targetEntity = toMany.getTargetEntity();
            for (Property targetProperty : toMany.getTargetProperties()) {
                if (targetEntity.propertiesColumns.contains(targetProperty)) continue;
                targetEntity.propertiesColumns.add(targetProperty);
            }
            if (toManyNames.add(toMany.getName().toLowerCase())) continue;
            throw new RuntimeException("Duplicate name for " + toMany);
        }
    }

    private void init3rdPassAdditionalImports() {
        Entity targetEntity;
        if (this.active.booleanValue() && !this.javaPackage.equals(this.javaPackageDao)) {
            this.additionalImportsEntity.add(this.javaPackageDao + "." + this.classNameDao);
        }
        for (ToOne toOne : this.toOneRelations) {
            targetEntity = toOne.getTargetEntity();
            this.checkAdditionalImportsEntityTargetEntity(targetEntity);
            if (targetEntity.getJavaPackage().equals(this.javaPackageDao)) continue;
            this.additionalImportsDao.add(targetEntity.getJavaPackage() + "." + targetEntity.getClassName());
        }
        for (ToMany toMany : this.toManyRelations) {
            targetEntity = toMany.getTargetEntity();
            this.checkAdditionalImportsEntityTargetEntity(targetEntity);
        }
    }

    private void checkAdditionalImportsEntityTargetEntity(Entity targetEntity) {
        if (!targetEntity.getJavaPackage().equals(this.javaPackage)) {
            this.additionalImportsEntity.add(targetEntity.getJavaPackage() + "." + targetEntity.getClassName());
        }
        if (!targetEntity.getJavaPackageDao().equals(this.javaPackage)) {
            this.additionalImportsEntity.add(targetEntity.getJavaPackageDao() + "." + targetEntity.getClassNameDao());
        }
    }

    public void validatePropertyExists(Property property) {
        if (!this.properties.contains(property)) {
            throw new RuntimeException("Property " + property + " does not exist in " + this);
        }
    }

    public String toString() {
        return "Entity " + this.className + " (package: " + this.javaPackage + ")";
    }
}

