/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;

public final class AsmUtils {
    private static final String REGEX_META_CHARS = ".^$+{}[]|()\\";
    private static final Pattern INTERNAL_PACKAGE_PATTERN;

    private AsmUtils() {
    }

    private static boolean isRegexMeta(char c) {
        return REGEX_META_CHARS.indexOf(c) != -1;
    }

    public static boolean isInternalClass(String className) {
        return INTERNAL_PACKAGE_PATTERN.matcher(className).matches();
    }

    public static String binaryToInternal(String clazz) {
        if (clazz.indexOf(47) >= 0 || clazz.indexOf(91) >= 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "'%s' is not a valid binary class name.", clazz));
        }
        return clazz.replace('.', '/');
    }

    public static boolean isGlob(String s) {
        return s.indexOf(42) >= 0 || s.indexOf(63) >= 0;
    }

    public static Pattern glob2Pattern(String ... globs) {
        StringBuilder regex = new StringBuilder();
        boolean needOr = false;
        for (String glob : globs) {
            if (needOr) {
                regex.append('|');
            }
            int i = 0;
            int len = glob.length();
            block5: while (i < len) {
                char c = glob.charAt(i++);
                switch (c) {
                    case '*': {
                        if (i < len && glob.charAt(i) == '*') {
                            regex.append(".*");
                            ++i;
                            continue block5;
                        }
                        regex.append("[^.]*");
                        continue block5;
                    }
                    case '?': {
                        regex.append("[^.]");
                        continue block5;
                    }
                }
                if (AsmUtils.isRegexMeta(c)) {
                    regex.append('\\');
                }
                regex.append(c);
            }
            needOr = true;
        }
        return Pattern.compile(regex.toString(), 0);
    }

    static {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String pkg : Arrays.asList("sun.", "oracle.", "com.sun.", "com.oracle.", "jdk.", "sunw.")) {
            sb.append(first ? (char)'(' : '|').append(Pattern.quote(pkg));
            first = false;
        }
        INTERNAL_PACKAGE_PATTERN = Pattern.compile(sb.append(").*").toString());
    }
}

