/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.ClassPatternRule;
import de.thetaphi.forbiddenapis.ClassScanner;
import de.thetaphi.forbiddenapis.ClassSignature;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.ForbiddenViolation;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.RelatedClassLookup;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import de.thetaphi.forbiddenapis.WrapperRuntimeException;
import de.thetaphi.forbiddenapis.asm.ClassReader;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Checker
implements RelatedClassLookup {
    public final boolean isSupportedJDK;
    private final long start;
    final Set<File> bootClassPathJars;
    final Set<String> bootClassPathDirs;
    final ClassLoader loader;
    final boolean internalRuntimeForbidden;
    final boolean failOnMissingClasses;
    final boolean defaultFailOnUnresolvableSignatures;
    final Map<String, ClassSignature> classesToCheck = new HashMap<String, ClassSignature>();
    final Map<String, ClassSignature> classpathClassCache = new HashMap<String, ClassSignature>();
    final Map<String, String> forbiddenFields = new HashMap<String, String>();
    final Map<String, String> forbiddenMethods = new HashMap<String, String>();
    final Map<String, String> forbiddenClasses = new HashMap<String, String>();
    final Set<ClassPatternRule> forbiddenClassPatterns = new LinkedHashSet<ClassPatternRule>();
    final Set<String> suppressAnnotations = new LinkedHashSet<String>();
    private static final String BUNDLED_PREFIX = "@includeBundled ";
    private static final String DEFAULT_MESSAGE_PREFIX = "@defaultMessage ";
    private static final String IGNORE_UNRESOLVABLE_LINE = "@ignoreUnresolvable";

    protected abstract void logError(String var1);

    protected abstract void logWarn(String var1);

    protected abstract void logInfo(String var1);

    public Checker(ClassLoader loader, boolean internalRuntimeForbidden, boolean failOnMissingClasses, boolean defaultFailOnUnresolvableSignatures) {
        this.loader = loader;
        this.internalRuntimeForbidden = internalRuntimeForbidden;
        this.failOnMissingClasses = failOnMissingClasses;
        this.defaultFailOnUnresolvableSignatures = defaultFailOnUnresolvableSignatures;
        this.start = System.currentTimeMillis();
        this.addSuppressAnnotation(SuppressForbidden.class);
        boolean isSupportedJDK = false;
        LinkedHashSet<File> bootClassPathJars = new LinkedHashSet<File>();
        LinkedHashSet<String> bootClassPathDirs = new LinkedHashSet<String>();
        try {
            URL objectClassURL = loader.getResource("java/lang/Object.class");
            if (objectClassURL != null && "jrt".equalsIgnoreCase(objectClassURL.getProtocol())) {
                isSupportedJDK = true;
            } else {
                RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
                if (rb.isBootClassPathSupported()) {
                    String cp = rb.getBootClassPath();
                    StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        File f = new File(st.nextToken());
                        if (f.isFile()) {
                            bootClassPathJars.add(f.getCanonicalFile());
                            continue;
                        }
                        if (!f.isDirectory()) continue;
                        String fp = f.getCanonicalPath();
                        if (!fp.endsWith(File.separator)) {
                            fp = fp + File.separator;
                        }
                        bootClassPathDirs.add(fp);
                    }
                }
                isSupportedJDK = !bootClassPathJars.isEmpty() || !bootClassPathDirs.isEmpty();
            }
        }
        catch (IOException ioe) {
            isSupportedJDK = false;
            bootClassPathJars.clear();
            bootClassPathDirs.clear();
        }
        this.bootClassPathJars = Collections.unmodifiableSet(bootClassPathJars);
        this.bootClassPathDirs = Collections.unmodifiableSet(bootClassPathDirs);
        if (isSupportedJDK) {
            try {
                isSupportedJDK = this.getClassFromClassLoader((String)Object.class.getName()).isRuntimeClass;
            }
            catch (IllegalArgumentException iae) {
                isSupportedJDK = false;
            }
            catch (ClassNotFoundException cnfe) {
                isSupportedJDK = false;
            }
        }
        this.isSupportedJDK = isSupportedJDK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSignature getClassFromClassLoader(String clazz) throws ClassNotFoundException {
        ClassSignature c;
        if (this.classpathClassCache.containsKey(clazz)) {
            c = this.classpathClassCache.get(clazz);
            if (c == null) {
                throw new ClassNotFoundException("Class '" + clazz + "' not found on classpath");
            }
        } else {
            try {
                URL url = this.loader.getResource(AsmUtils.binaryToInternal(clazz) + ".class");
                if (url == null) {
                    this.classpathClassCache.put(clazz, null);
                    throw new ClassNotFoundException("Class '" + clazz + "' not found on classpath");
                }
                boolean isRuntimeClass = false;
                URLConnection conn = url.openConnection();
                if ("file".equalsIgnoreCase(url.getProtocol())) {
                    try {
                        String path = new File(url.toURI()).getCanonicalPath();
                        for (String bcpDir : this.bootClassPathDirs) {
                            if (!path.startsWith(bcpDir)) continue;
                            isRuntimeClass = true;
                        }
                    }
                    catch (URISyntaxException use) {}
                } else if ("jar".equalsIgnoreCase(url.getProtocol()) && conn instanceof JarURLConnection) {
                    URL jarUrl = ((JarURLConnection)conn).getJarFileURL();
                    if ("file".equalsIgnoreCase(jarUrl.getProtocol())) {
                        try {
                            File jarFile = new File(jarUrl.toURI()).getCanonicalFile();
                            isRuntimeClass = this.bootClassPathJars.contains(jarFile);
                        }
                        catch (URISyntaxException use) {}
                    }
                } else if ("jrt".equalsIgnoreCase(url.getProtocol())) {
                    isRuntimeClass = true;
                }
                InputStream in = conn.getInputStream();
                try {
                    c = new ClassSignature(new ClassReader(in), isRuntimeClass, false);
                    this.classpathClassCache.put(clazz, c);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                this.classpathClassCache.put(clazz, null);
                throw new ClassNotFoundException("I/O error while loading of class '" + clazz + "'", ioe);
            }
        }
        return c;
    }

    @Override
    public ClassSignature lookupRelatedClass(String internalName) {
        Type type = Type.getObjectType(internalName);
        if (type.getSort() != 10) {
            return null;
        }
        ClassSignature c = this.classesToCheck.get(internalName);
        if (c == null) {
            try {
                c = this.getClassFromClassLoader(type.getClassName());
            }
            catch (ClassNotFoundException cnfe) {
                if (this.failOnMissingClasses) {
                    throw new WrapperRuntimeException(cnfe);
                }
                this.logWarn(String.format(Locale.ENGLISH, "The referenced class '%s' cannot be loaded. Please fix the classpath!", type.getClassName()));
            }
        }
        return c;
    }

    private void reportParseFailed(boolean failOnUnresolvableSignatures, String message, String signature) throws ParseException {
        if (failOnUnresolvableSignatures) {
            throw new ParseException(String.format(Locale.ENGLISH, "%s while parsing signature: %s", message, signature));
        }
        this.logWarn(String.format(Locale.ENGLISH, "%s while parsing signature: %s [signature ignored]", message, signature));
    }

    private void addSignature(String line, String defaultMessage, boolean failOnUnresolvableSignatures) throws ParseException {
        String printout;
        String field;
        Method method;
        String clazz;
        String message;
        String signature;
        int p = line.indexOf(64);
        if (p >= 0) {
            signature = line.substring(0, p).trim();
            message = line.substring(p + 1).trim();
        } else {
            signature = line;
            message = defaultMessage;
        }
        p = signature.indexOf(35);
        if (p >= 0) {
            clazz = signature.substring(0, p);
            String s = signature.substring(p + 1);
            if ((p = s.indexOf(40)) >= 0) {
                if (p == 0) {
                    throw new ParseException("Invalid method signature (method name missing): " + signature);
                }
                try {
                    method = Method.getMethod("void " + s, true);
                }
                catch (IllegalArgumentException iae) {
                    throw new ParseException("Invalid method signature: " + signature);
                }
                field = null;
            } else {
                field = s;
                method = null;
            }
        } else {
            clazz = signature;
            method = null;
            field = null;
        }
        String string = printout = message != null && message.length() > 0 ? signature + " [" + message + "]" : signature;
        if (AsmUtils.isGlob(clazz)) {
            if (method != null || field != null) {
                throw new ParseException(String.format(Locale.ENGLISH, "Class level glob pattern cannot be combined with methods/fields: %s", signature));
            }
            this.forbiddenClassPatterns.add(new ClassPatternRule(clazz, printout));
        } else {
            ClassSignature c;
            try {
                c = this.getClassFromClassLoader(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                this.reportParseFailed(failOnUnresolvableSignatures, cnfe.getMessage(), signature);
                return;
            }
            if (method != null) {
                assert (field == null);
                boolean found = false;
                for (Method m : c.methods) {
                    if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getArgumentTypes(), method.getArgumentTypes())) continue;
                    found = true;
                    this.forbiddenMethods.put(c.className + '\u0000' + m, printout);
                }
                if (!found) {
                    this.reportParseFailed(failOnUnresolvableSignatures, "Method not found", signature);
                    return;
                }
            } else if (field != null) {
                assert (method == null);
                if (!c.fields.contains(field)) {
                    this.reportParseFailed(failOnUnresolvableSignatures, "Field not found", signature);
                    return;
                }
                this.forbiddenFields.put(c.className + '\u0000' + field, printout);
            } else {
                assert (field == null && method == null);
                this.forbiddenClasses.put(c.className, printout);
            }
        }
    }

    public final void parseBundledSignatures(String name, String jdkTargetVersion) throws IOException, ParseException {
        if (!name.matches("[A-Za-z0-9\\-\\.]+")) {
            throw new ParseException("Invalid bundled signature reference: " + name);
        }
        InputStream in = this.getClass().getResourceAsStream("signatures/" + name + ".txt");
        if (in == null && jdkTargetVersion != null && name.startsWith("jdk-") && !name.matches(".*?\\-\\d\\.\\d")) {
            name = name + "-" + jdkTargetVersion;
            in = this.getClass().getResourceAsStream("signatures/" + name + ".txt");
        }
        if (in == null) {
            throw new FileNotFoundException("Bundled signatures resource not found: " + name);
        }
        this.parseSignaturesFile(in, true);
    }

    public final void parseSignaturesFile(InputStream in) throws IOException, ParseException {
        this.parseSignaturesFile(in, false);
    }

    public final void parseSignaturesString(String signatures) throws IOException, ParseException {
        this.parseSignaturesFile(new StringReader(signatures), false);
    }

    private void parseSignaturesFile(InputStream in, boolean allowBundled) throws IOException, ParseException {
        this.parseSignaturesFile(new InputStreamReader(in, "UTF-8"), allowBundled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSignaturesFile(Reader reader, boolean allowBundled) throws IOException, ParseException {
        BufferedReader r = new BufferedReader(reader);
        try {
            String line;
            String defaultMessage = null;
            boolean failOnUnresolvableSignatures = this.defaultFailOnUnresolvableSignatures;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("@")) {
                    if (allowBundled && line.startsWith(BUNDLED_PREFIX)) {
                        String name = line.substring(BUNDLED_PREFIX.length()).trim();
                        this.parseBundledSignatures(name, null);
                        continue;
                    }
                    if (line.startsWith(DEFAULT_MESSAGE_PREFIX)) {
                        defaultMessage = line.substring(DEFAULT_MESSAGE_PREFIX.length()).trim();
                        if (defaultMessage.length() != 0) continue;
                        defaultMessage = null;
                        continue;
                    }
                    if (line.equals(IGNORE_UNRESOLVABLE_LINE)) {
                        failOnUnresolvableSignatures = false;
                        continue;
                    }
                    throw new ParseException("Invalid line in signature file: " + line);
                }
                this.addSignature(line, defaultMessage, failOnUnresolvableSignatures);
            }
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClassToCheck(InputStream in) throws IOException {
        ClassReader reader;
        try {
            reader = new ClassReader(in);
        }
        finally {
            in.close();
        }
        this.classesToCheck.put(reader.getClassName(), new ClassSignature(reader, false, true));
    }

    public final boolean hasNoSignatures() {
        return this.forbiddenMethods.isEmpty() && this.forbiddenFields.isEmpty() && this.forbiddenClasses.isEmpty() && this.forbiddenClassPatterns.isEmpty() && !this.internalRuntimeForbidden;
    }

    public final void addSuppressAnnotation(Class<? extends Annotation> anno) {
        this.suppressAnnotations.add(anno.getName());
    }

    public final void addSuppressAnnotation(String annoName) {
        this.suppressAnnotations.add(annoName);
    }

    private int checkClass(ClassReader reader, Pattern suppressAnnotationsPattern) {
        String className = Type.getObjectType(reader.getClassName()).getClassName();
        ClassScanner scanner = new ClassScanner(this, this.forbiddenClasses, this.forbiddenClassPatterns, this.forbiddenMethods, this.forbiddenFields, suppressAnnotationsPattern, this.internalRuntimeForbidden);
        reader.accept(scanner, 4);
        List<ForbiddenViolation> violations = scanner.getSortedViolations();
        Pattern splitter = Pattern.compile(Pattern.quote("\n"));
        for (ForbiddenViolation v : violations) {
            for (String line : splitter.split(v.format(className, scanner.getSourceFile()))) {
                this.logError(line);
            }
        }
        return violations.size();
    }

    public final void run() throws ForbiddenApiException {
        int errors = 0;
        Pattern suppressAnnotationsPattern = AsmUtils.glob2Pattern(this.suppressAnnotations.toArray(new String[this.suppressAnnotations.size()]));
        try {
            for (ClassSignature c : this.classesToCheck.values()) {
                errors += this.checkClass(c.getReader(), suppressAnnotationsPattern);
            }
        }
        catch (WrapperRuntimeException wre) {
            Throwable cause = wre.getCause();
            throw new ForbiddenApiException("Check for forbidden API calls failed: " + cause.toString());
        }
        String message = String.format(Locale.ENGLISH, "Scanned %d (and %d related) class file(s) for forbidden API invocations (in %.2fs), %d error(s).", this.classesToCheck.size(), this.classesToCheck.isEmpty() ? 0 : this.classpathClassCache.size(), (double)(System.currentTimeMillis() - this.start) / 1000.0, errors);
        if (errors > 0) {
            this.logError(message);
            throw new ForbiddenApiException("Check for forbidden API calls failed, see log.");
        }
        this.logInfo(message);
    }
}

