/*
 *    EventPluginTestCase.java
 *
 *    Copyright 2002, Bill2, Inc. All rights reserved.
 *
 *    This program contains the confidential trade secret
 *    information of Bill2, Inc.  Use, disclosure, or
 *    copying without written consent is strictly prohibited.
 *
 *    @author topping
 *    @version $Revision$
 */
package org.dentaku.gentaku.cartridge.event;

import org.xdoclet.AbstractJavaGeneratingPluginTestCase;
import org.generama.AbstractPlugin;
import org.generama.MetadataProvider;
import org.generama.WriterMapper;
import org.generama.velocity.ClasspathVelocityComponent;
import org.dentaku.gentaku.RepositoryReader;
import org.dentaku.gentaku.MagicDrawRepositoryReader;
import org.dentaku.gentaku.JMIUMLMetadataProvider;
import org.dentaku.gentaku.cartridge.CartridgeTestUtils;

import java.io.Reader;
import java.io.StringReader;

public class EventPluginTestCase extends AbstractJavaGeneratingPluginTestCase {
    protected AbstractPlugin createPlugin(MetadataProvider metadataProvider, WriterMapper writerMapper) throws Exception {
        return new EventPlugin(metadataProvider, writerMapper, new ClasspathVelocityComponent());
    }

    protected Reader getExpected() throws Exception {
        return null;
    }

    public void testGenerateContent() throws Throwable {
        plugin.start();

        // just print it out for now
        String actualString = writerMapper.getContent();
        System.out.println(actualString);
    }

    protected MetadataProvider createMetadataProvider() throws Exception {
        RepositoryReader reader = new MagicDrawRepositoryReader(CartridgeTestUtils.getResourceURLRelativeToParentPackage(getClass(), "TestModel.xml.zip"));
        return new JMIUMLMetadataProvider(reader);
    }
}
