package org.dentaku.gentaku.cartridge.event.graph;

import java.util.Collection;

public class ReverseGraphIterator implements GraphIterator {

    private final GraphIterator navigator;

    public ReverseGraphIterator(GraphIterator navigator) {
        this.navigator = navigator;
    }

    public Collection nextEdges(Object vertex) {
        return navigator.prevEdges(vertex);
    }

    public Collection prevEdges(Object vertex) {
        return navigator.nextEdges(vertex);
    }

    // get the target of an edge
    public Object getSource(Object edge) {
        return navigator.getTarget(edge);
    }

    public Object getTarget(Object edge) {
        return navigator.getSource(edge);
    }
}
