/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.gentaku.cartridge.entity;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dentaku.gentaku.JMIUMLMetadataProvider;
import org.dentaku.gentaku.cartridge.UMLUtils;
import org.dentaku.gentaku.cartridge.UmlUtilsProvider;
import org.generama.AbstractPlugin;
import org.generama.MetadataProvider;
import org.generama.WriterMapper;
import org.generama.defaults.FileWriterMapper;
import org.generama.defaults.JavaGeneratingPlugin;
import org.generama.velocity.VelocityComponent;

public class EntityBase
extends JavaGeneratingPlugin
implements UmlUtilsProvider {
    private boolean createonly;
    private List stereotypes;
    protected UMLUtils umlUtils;

    public EntityBase(MetadataProvider metadataProvider, WriterMapper writerMapper, VelocityComponent velocityComponent) {
        super(metadataProvider, (WriterMapper)new CheckFileWriterMapper(writerMapper), velocityComponent);
        this.setMultioutput(true);
        this.umlUtils = UMLUtils.getInstance((JMIUMLMetadataProvider)this.getMetadataProvider(), (AbstractPlugin)this);
        this.stereotypes = new ArrayList();
    }

    public boolean shouldGenerate(Object metadata) {
        String stereotypeName = null;
        if (this.stereotypes.size() == 0) {
            String className = this.getClass().getName();
            String pluginName = className.substring(className.lastIndexOf(".") + 1);
            stereotypeName = pluginName.substring(0, pluginName.indexOf("Plugin"));
            return this.umlUtils.matchesStereotype(metadata, stereotypeName);
        }
        Iterator it = this.stereotypes.iterator();
        while (it.hasNext()) {
            stereotypeName = (String)it.next();
            if (!this.umlUtils.matchesStereotype(metadata, stereotypeName)) continue;
            return true;
        }
        return false;
    }

    public boolean isCreateonly() {
        return this.createonly;
    }

    public void setCreateonly(boolean createOnly) {
        this.createonly = createOnly;
        ((CheckFileWriterMapper)this.getWriterMapper()).setCreateonly(createOnly);
    }

    public List getStereotypes() {
        return this.stereotypes;
    }

    public void setStereotypes(List stereotypes) {
        this.stereotypes = stereotypes;
    }

    public UMLUtils getUmlUtils() {
        return this.umlUtils;
    }

    private static class CheckFileWriterMapper
    implements WriterMapper {
        private WriterMapper delegate;
        private boolean createOnly;

        public CheckFileWriterMapper(WriterMapper delegate) {
            this.delegate = delegate;
        }

        public Writer getWriter(Object metadata, AbstractPlugin plugin) throws IOException {
            Writer result = null;
            if (this.delegate instanceof FileWriterMapper) {
                String pakkage = plugin.getDestinationPackage(metadata);
                String packagePath = pakkage.replace('.', '/');
                File dir = new File(plugin.getDestdirFile(), packagePath);
                dir.mkdirs();
                String filename = plugin.getDestinationFilename(metadata);
                File out = new File(dir, filename);
                if (!this.createOnly || !out.exists()) {
                    try {
                        result = new OutputStreamWriter((OutputStream)new FileOutputStream(out), plugin.getEncoding());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IOException(e.toString());
                    }
                }
            } else {
                result = this.delegate.getWriter(metadata, plugin);
            }
            return result;
        }

        public boolean isCreateonly() {
            return this.createOnly;
        }

        public void setCreateonly(boolean createOnly) {
            this.createOnly = createOnly;
        }
    }
}

