/*
 * Decompiled with CFR 0.152.
 */
package org.dentaku.gentaku.cartridge.event.graph;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.dentaku.gentaku.cartridge.event.graph.GraphException;
import org.dentaku.gentaku.cartridge.event.graph.GraphIterator;
import org.dentaku.gentaku.cartridge.event.graph.GraphResults;
import org.dentaku.gentaku.cartridge.event.graph.ReverseGraphIterator;
import org.omg.uml.behavioralelements.statemachines.StateVertex;
import org.omg.uml.behavioralelements.statemachines.Transition;

public class GraphProcessor {
    private GraphResults dfsResults = null;
    private GraphResults sccResults = null;
    private ArrayList topological = null;

    public GraphResults scc(Collection verticies, GraphIterator nav) {
        this.dfsResults = this.dfs(verticies, nav);
        this.topological = this.topologicalSort(this.dfsResults);
        this.sccResults = this.dfs(this.topological, new ReverseGraphIterator(nav));
        return this.sccResults;
    }

    public GraphResults dfs(Collection verticies, GraphIterator nav) {
        GraphResults results = new GraphResults();
        Iterator it = verticies.iterator();
        while (it.hasNext()) {
            Object vertex = it.next();
            if (results.getDiscoveredVertex().containsKey(vertex)) continue;
            Collection roots = results.getRoots();
            if (roots != null) {
                roots.add(vertex);
            }
            this.dfsVisit(results, vertex, nav);
        }
        return results;
    }

    private ArrayList topologicalSort(GraphResults resultSet1) {
        Object[] finished = resultSet1.getFinishedVertex().toArray();
        ArrayList<Object> topological = new ArrayList<Object>(finished.length);
        for (int i = finished.length - 1; i >= 0; --i) {
            topological.add(finished[i]);
        }
        return topological;
    }

    private void dfsVisit(GraphResults results, Object vertex, GraphIterator nav) {
        results.getDiscoveredVertex().put(vertex, new Integer(results.getNextTime()));
        Collection nextEdges = nav.nextEdges(vertex);
        Iterator i = nextEdges.iterator();
        while (i.hasNext()) {
            Object nextEdge = i.next();
            Object nextVertex = nav.getTarget(nextEdge);
            System.out.println("dfsVisit: thisVertex=" + ((StateVertex)vertex).getName() + "; nextEdge=" + this.getEdgeType(results, nextEdge) + "; nextVertex=" + ((StateVertex)nextVertex).getName());
            this.classifyEdge(results, nav, nextEdge);
            if (results.getDiscoveredVertex().containsKey(nextVertex)) continue;
            this.dfsVisit(results, nextVertex, nav);
        }
        results.getFinishedVertex().add(vertex);
    }

    private void classifyEdge(GraphResults results, GraphIterator nav, Object edge) {
        Object source = nav.getSource(edge);
        Object target = nav.getTarget(edge);
        if (results.getFinishedVertex().contains(target)) {
            int targetTime;
            int sourceTime = (Integer)results.getDiscoveredVertex().get(source);
            if (sourceTime < (targetTime = ((Integer)results.getDiscoveredVertex().get(target)).intValue())) {
                System.out.println("classifyEdge - FORWARD: source=" + ((StateVertex)source).getName() + "; dest=" + ((StateVertex)target).getName());
                results.getForwardEdges().add(edge);
            } else {
                System.out.println("classifyEdge - CROSS: source=" + ((StateVertex)source).getName() + "; dest=" + ((StateVertex)target).getName());
                results.getCrossEdges().add(edge);
            }
        } else if (results.getDiscoveredVertex().containsKey(target)) {
            System.out.println("classifyEdge - BACK: source=" + ((StateVertex)source).getName() + "; dest=" + ((StateVertex)target).getName());
            results.getBackEdges().add(edge);
        } else {
            System.out.println("classifyEdge - TREE: source=" + ((StateVertex)source).getName() + "; dest=" + ((StateVertex)target).getName());
            results.getTreeEdges().add(edge);
        }
    }

    private String getEdgeType(GraphResults results, Object edge) {
        if (results.getBackEdges().contains(edge)) {
            return "back";
        }
        if (results.getForwardEdges().contains(edge)) {
            return "forward";
        }
        if (results.getCrossEdges().contains(edge)) {
            return "cross";
        }
        if (results.getTreeEdges().contains(edge)) {
            return "tree";
        }
        return "unknown";
    }

    public void validate(Collection verticies, GraphIterator nav) throws GraphException {
        this.dfsResults = this.dfs(verticies, nav);
        this.topological = this.topologicalSort(this.dfsResults);
        this.sccResults = this.dfs(this.topological, new ReverseGraphIterator(nav));
        StateVertex lastVertex = null;
        Iterator it = ((AbstractList)this.topological).iterator();
        lastVertex = (StateVertex)it.next();
        while (it.hasNext()) {
            StateVertex thisVertex = (StateVertex)it.next();
            Collection outgoing = lastVertex.getOutgoing();
            if (outgoing.size() != 1 || ((Transition)lastVertex.getOutgoing().iterator().next()).getTarget() != thisVertex) {
                throw new GraphException("graph is not a single path");
            }
            lastVertex = thisVertex;
        }
    }

    public GraphResults getDfsResults() {
        return this.dfsResults;
    }

    public GraphResults getSccResults() {
        return this.sccResults;
    }

    public ArrayList getTopological() {
        return this.topological;
    }
}

