/*
 * RuleValve.java
 * Copyright 2002-2004 Bill2, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dentaku.foundation.orphan;

import org.dentaku.services.rules.JSR94RuleProcessor;
import org.dentaku.foundation.event.AbstractEvent;
import org.dentaku.foundation.pipeline.Valve;

import javax.rules.StatelessRuleSession;
import java.util.ArrayList;

public class RuleValve implements Valve {
    private JSR94RuleProcessor rulesEngine = null;

    public boolean execute(AbstractEvent event) throws Exception {
        StatelessRuleSession srs = rulesEngine.getStatelessRuleSession();
        ArrayList list = new ArrayList();
        list.add(event);
        srs.executeRules(list);
        return true;
    }
}
