/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.codec.mina;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.asn1.codec.EncoderException;
import org.apache.asn1.codec.stateful.EncoderCallback;
import org.apache.asn1.codec.stateful.StatefulEncoder;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolEncoderOutput;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;

public class Asn1CodecEncoder
implements ProtocolEncoder {
    private final StatefulEncoder encoder;
    private final EncoderCallbackImpl callback = new EncoderCallbackImpl();

    public Asn1CodecEncoder(StatefulEncoder encoder) {
        encoder.setCallback(this.callback);
        this.encoder = encoder;
    }

    public void encode(ProtocolSession session, Object message, ProtocolEncoderOutput out) throws ProtocolViolationException {
        this.callback.encOut = out;
        try {
            this.encoder.encode(message);
        }
        catch (EncoderException e) {
            throw new ProtocolViolationException("Encoding failed.", (Throwable)e);
        }
    }

    private class EncoderCallbackImpl
    implements EncoderCallback {
        private ProtocolEncoderOutput encOut;

        private EncoderCallbackImpl() {
        }

        public void encodeOccurred(StatefulEncoder codec, Object encoded) {
            if (encoded instanceof java.nio.ByteBuffer) {
                java.nio.ByteBuffer buf = (java.nio.ByteBuffer)encoded;
                ByteBuffer wrappedBuf = ByteBuffer.wrap((java.nio.ByteBuffer)buf);
                wrappedBuf.acquire();
                this.encOut.write(wrappedBuf);
            } else if (encoded instanceof Object[]) {
                Object[] bufArray = (Object[])encoded;
                for (int i = 0; i < bufArray.length; ++i) {
                    this.encodeOccurred(codec, bufArray[i]);
                }
                this.encOut.mergeAll();
            } else if (encoded instanceof Iterator) {
                Iterator it = (Iterator)encoded;
                while (it.hasNext()) {
                    this.encodeOccurred(codec, it.next());
                }
                this.encOut.mergeAll();
            } else if (encoded instanceof Collection) {
                Iterator it = ((Collection)encoded).iterator();
                while (it.hasNext()) {
                    this.encodeOccurred(codec, it.next());
                }
                this.encOut.mergeAll();
            } else if (encoded instanceof Enumeration) {
                Enumeration e = (Enumeration)encoded;
                while (e.hasMoreElements()) {
                    this.encodeOccurred(codec, e.nextElement());
                }
                this.encOut.mergeAll();
            } else {
                throw new IllegalArgumentException("Encoded result is not a ByteBuffer: " + encoded.getClass());
            }
        }
    }
}

