/*
 * Decompiled with CFR 0.152.
 */
package javax.jcr;

import java.util.Calendar;
import javax.jcr.BaseValue;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;

public class BooleanValue
extends BaseValue {
    public static final int TYPE = 6;
    private final Boolean bool;

    public BooleanValue(Boolean bool) {
        super(6);
        this.bool = bool;
    }

    public BooleanValue(boolean bool) {
        super(6);
        this.bool = new Boolean(bool);
    }

    public static BooleanValue valueOf(String s) {
        return new BooleanValue(Boolean.valueOf(s));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BooleanValue) {
            BooleanValue other = (BooleanValue)obj;
            if (this.bool == other.bool) {
                return true;
            }
            if (this.bool != null && other.bool != null) {
                return this.bool.equals(other.bool);
            }
        }
        return false;
    }

    protected String getInternalString() throws ValueFormatException {
        if (this.bool != null) {
            return this.bool.toString();
        }
        throw new ValueFormatException("empty value");
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to date failed: inconvertible types");
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to long failed: inconvertible types");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        if (this.bool != null) {
            return this.bool;
        }
        throw new ValueFormatException("empty value");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        throw new ValueFormatException("conversion to double failed: inconvertible types");
    }
}

