/*
 * Decompiled with CFR 0.152.
 */
package javax.jcr;

import java.util.Calendar;
import javax.jcr.BaseValue;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.util.ISO8601;

public class DateValue
extends BaseValue {
    public static final int TYPE = 5;
    private final Calendar date;

    public DateValue(Calendar date) {
        super(5);
        this.date = date;
    }

    public static DateValue valueOf(String s) throws ValueFormatException {
        Calendar cal = ISO8601.parse(s);
        if (cal != null) {
            return new DateValue(cal);
        }
        throw new ValueFormatException("not a valid date format");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DateValue) {
            DateValue other = (DateValue)obj;
            if (this.date == other.date) {
                return true;
            }
            if (this.date != null && other.date != null) {
                return this.date.equals(other.date);
            }
        }
        return false;
    }

    protected String getInternalString() throws ValueFormatException {
        if (this.date != null) {
            return ISO8601.format(this.date);
        }
        throw new ValueFormatException("empty value");
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        if (this.date != null) {
            return this.date;
        }
        throw new ValueFormatException("empty value");
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        if (this.date != null) {
            return this.date.getTimeInMillis();
        }
        throw new ValueFormatException("empty value");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        if (this.date != null) {
            throw new ValueFormatException("cannot convert date to boolean");
        }
        throw new ValueFormatException("empty value");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        this.setValueConsumed();
        if (this.date != null) {
            long ms = this.date.getTimeInMillis();
            if ((double)ms <= Double.MAX_VALUE) {
                return ms;
            }
            throw new ValueFormatException("conversion from date to double failed: inconvertible types");
        }
        throw new ValueFormatException("empty value");
    }
}

