/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.util.PathUtil;

public class ItemLocation
implements Comparable {
    public static final String ROOT_PATH = "/";
    public static final String ROOT_URI = "[]:1";
    public static final int NOT_DEFINED = 0;
    private NamespaceAccessor namespaces;
    private List names = new ArrayList();

    public ItemLocation(String absPath, NamespaceAccessor namespaces) throws PathNotFoundException, RepositoryException {
        this.namespaces = namespaces;
        this.names = this.parseNames(PathUtil.makeCanonicalPath(absPath), true);
        this.rewriteAncestorIndexes();
    }

    public ItemLocation(String absPath, int index, NamespaceAccessor namespaces) throws PathNotFoundException, RepositoryException {
        this.namespaces = namespaces;
        this.names = this.parseNames(PathUtil.makeCanonicalPath(absPath), true);
        this.rewriteAncestorIndexes();
        this.setIndex(index);
    }

    public ItemLocation(String parentAbsPath, String path, NamespaceAccessor namespaces) throws PathNotFoundException, RepositoryException {
        this.namespaces = namespaces;
        this.names = this.parseNames(PathUtil.makeCanonicalPath(parentAbsPath, path), true);
        this.rewriteAncestorIndexes();
    }

    public ItemLocation(String internalPath, boolean internal, NamespaceAccessor namespaces) throws PathNotFoundException, RepositoryException {
        this.namespaces = namespaces;
        this.names = this.parseInternalNames(internalPath);
        this.rewriteAncestorIndexes();
    }

    public ItemLocation(String internalPath) throws PathNotFoundException {
        this.names = this.parseInternalNames(internalPath);
        this.rewriteAncestorIndexes();
    }

    private ItemLocation(List names, NamespaceAccessor namespaces) throws PathNotFoundException, RepositoryException {
        this.namespaces = namespaces;
        this.names = names;
        this.rewriteAncestorIndexes();
    }

    private void rewriteAncestorIndexes() {
        for (int i = 0; i < this.names.size(); ++i) {
            QName n = (QName)this.names.get(i);
            if (i >= this.names.size() - 1 || n.getIndex() != 0) continue;
            n.setIndex(1);
        }
    }

    public ItemLocation makeChildLocation(String relPath) throws PathNotFoundException, RepositoryException {
        ArrayList<QName> newNames = new ArrayList<QName>();
        for (int i = 0; i < this.names.size(); ++i) {
            QName n = (QName)this.names.get(i);
            newNames.add(n);
        }
        newNames.addAll(this.parseNames(relPath, false));
        return new ItemLocation(newNames, this.namespaces);
    }

    public ItemLocation makeParentLocation() throws PathNotFoundException, RepositoryException {
        return this.makeAncestorLocation(1);
    }

    public ItemLocation makeAncestorLocation(int relativeDegree) throws PathNotFoundException, RepositoryException {
        ArrayList<QName> newNames = new ArrayList<QName>();
        if (relativeDegree > this.size() || this.size() <= 1) {
            throw new PathNotFoundException("Relative degree " + relativeDegree + " is more than depth for " + this.getPath());
        }
        for (int i = 0; i < this.size() - relativeDegree; ++i) {
            QName n = (QName)this.names.get(i);
            newNames.add(n);
        }
        return new ItemLocation(newNames, this.namespaces);
    }

    NamespaceAccessor getNamespaces() {
        return this.namespaces;
    }

    public String getName() {
        return this.getQName(this.size() - 1).getAsNoIndexString();
    }

    public String getInternalName() {
        return this.getQName(this.size() - 1).getAsInternalString();
    }

    public String getPath() {
        String path = "";
        if (this.size() == 1) {
            return ROOT_PATH;
        }
        for (int i = 1; i < this.size(); ++i) {
            path = path + ROOT_PATH + this.getQName(i).getAsString();
        }
        return path;
    }

    public String getInternalPath() {
        String path = "";
        for (int i = 0; i < this.size(); ++i) {
            path = path + this.getQName(i).getAsInternalString();
        }
        return path;
    }

    public int getDepth() {
        return this.size() - 1;
    }

    public boolean isDescendantOf(ItemLocation anotherLocation, boolean childOnly) {
        int depthDiff = this.getDepth() - anotherLocation.getDepth();
        if (depthDiff <= 0 || childOnly && depthDiff != 1) {
            return false;
        }
        List anotherNames = anotherLocation.getNames();
        for (int i = 0; i < anotherNames.size(); ++i) {
            boolean result = anotherNames.get(i).equals(this.names.get(i));
            if (result) continue;
            return false;
        }
        return true;
    }

    private int size() {
        return this.names.size();
    }

    public int getIndex() {
        return this.getQName(this.size() - 1).getIndex();
    }

    public void setIndex(int index) {
        this.getQName(this.size() - 1).setIndex(index);
    }

    public boolean isIndexDefined() {
        return this.getIndex() != 0;
    }

    public int hashCode() {
        return this.getInternalPath().hashCode();
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof ItemLocation)) {
            return 1;
        }
        ItemLocation anotherLoc = (ItemLocation)obj;
        if (this.size() != anotherLoc.size()) {
            return this.size() - anotherLoc.size();
        }
        for (int i = 0; i < this.size(); ++i) {
            int comp = this.getQName(i).compareTo(anotherLoc.getQName(i));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    private List parseNames(String path, boolean absolute) throws PathNotFoundException, RepositoryException {
        ArrayList<QName> list = new ArrayList<QName>();
        int start = 0;
        if (!absolute) {
            start = -1;
        }
        if (path.startsWith(ROOT_PATH)) {
            if (!absolute) {
                throw new RepositoryException("Illegal relPath " + path);
            }
            list.add(new QName(this.namespaces.getNamespaceURIByPrefix(""), "", 0));
        } else if (absolute) {
            throw new RepositoryException("Illegal absPath " + path);
        }
        int end = 0;
        while (end >= 0) {
            end = path.indexOf(47, start + 1);
            String qname = path.substring(start + 1, end == -1 ? path.length() : end);
            if (qname.length() == 0) {
                return list;
            }
            QName part = this.parseQName(qname);
            list.add(part);
            start = end;
        }
        return list;
    }

    private QName parseQName(String qname) throws PathNotFoundException, RepositoryException {
        int index = 0;
        int delim = qname.indexOf(":");
        int endOfName = qname.length();
        int indexStart = qname.indexOf("[");
        if (indexStart > 0) {
            int indexEnd = qname.indexOf("]");
            index = Integer.parseInt(qname.substring(indexStart + 1, indexEnd));
            endOfName = indexStart;
        }
        try {
            if (delim <= 0) {
                return new QName(this.namespaces.getNamespaceURIByPrefix(""), qname.substring(0, endOfName), index);
            }
            return new QName(this.namespaces.getNamespaceURIByPrefix(qname.substring(0, delim)), qname.substring(delim + 1, endOfName), index);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RepositoryException(e.getMessage());
        }
    }

    private List parseInternalNames(String path) throws PathNotFoundException {
        ArrayList<QName> list = new ArrayList<QName>();
        if (path.length() < 2 || !path.startsWith("[]")) {
            throw new PathNotFoundException("Bad internal path '" + path + "'");
        }
        int uriStart = 0;
        while (uriStart >= 0) {
            uriStart = path.indexOf("[", uriStart);
            int uriFinish = path.indexOf("]", uriStart);
            String uri = path.substring(uriStart + 1, uriFinish);
            int tmp = path.indexOf("[", uriFinish);
            if (tmp == -1) {
                tmp = path.length();
                uriStart = -1;
            } else {
                uriStart = tmp;
            }
            String localName = path.substring(uriFinish + 1, tmp);
            int index = 0;
            int ind = localName.indexOf(":");
            if (ind != -1) {
                index = Integer.parseInt(localName.substring(ind + 1));
                localName = localName.substring(0, ind);
            }
            QName qName = new QName(uri, localName, index);
            list.add(qName);
        }
        return list;
    }

    public QName getQName(int depth) {
        return (QName)this.names.get(depth);
    }

    List getNames() {
        return this.names;
    }

    public class QName {
        private String uri;
        private String localName;
        private int index = 0;

        public QName(String uri, String localName, int index) {
            this.uri = uri;
            this.localName = localName;
            this.index = index;
        }

        public String getURI() {
            return this.uri;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getPrefix() {
            try {
                return ItemLocation.this.namespaces.getNamespacePrefixByURI(this.uri);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getAsInternalString() {
            String indexStr = "";
            if (this.index != 0) {
                indexStr = ":" + this.index;
            }
            return "[" + this.uri + "]" + this.localName + indexStr;
        }

        public String getAsNoIndexString() {
            String delim = this.getPrefix().length() == 0 ? "" : ":";
            return this.getPrefix() + delim + this.localName;
        }

        public String getAsNoIndexInternalString() {
            return "[" + this.uri + "]" + this.localName;
        }

        public String getAsString() {
            String indexStr = "";
            if (this.index != 0 && this.index != 1) {
                indexStr = "[" + this.index + "]";
            }
            String delim = this.getPrefix().length() == 0 ? "" : ":";
            return this.getPrefix() + delim + this.localName + indexStr;
        }

        public String toString() {
            return this.getAsInternalString();
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int compareTo(Object obj) {
            int i;
            if (!(obj instanceof QName)) {
                return 1;
            }
            QName anotherObj = (QName)obj;
            int index1 = this.getIndex();
            int index2 = anotherObj.getIndex();
            if (index1 == 0) {
                index1 = index2;
            } else if (index2 == 0) {
                index2 = index1;
            }
            String strInd1 = "";
            String strInd2 = "";
            for (i = 0; i < index1; ++i) {
                strInd1 = strInd1 + "1";
            }
            for (i = 0; i < index2; ++i) {
                strInd2 = strInd2 + "1";
            }
            String str1 = this.getAsNoIndexInternalString() + ":" + strInd1;
            String str2 = anotherObj.getAsNoIndexInternalString() + ":" + strInd2;
            return str1.compareTo(str2);
        }
    }
}

