/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util;

import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.PathNotFoundException;

public class PathUtil {
    public static String makeCanonicalPath(String absolutePath) throws PathNotFoundException {
        if (!absolutePath.startsWith("/")) {
            throw new PathNotFoundException("'" + absolutePath + "' is not an absolute path");
        }
        if (absolutePath.indexOf("./") >= 0 || absolutePath.indexOf("/.") >= 0) {
            LinkedList<String> queue = new LinkedList<String>();
            int start = 0;
            while (start >= 0) {
                int end = absolutePath.indexOf(47, start + 1);
                String element = absolutePath.substring(start + 1, end == -1 ? absolutePath.length() : end);
                if (!element.equals(".")) {
                    if (element.equals("..")) {
                        if (queue.isEmpty()) {
                            throw new PathNotFoundException("'" + absolutePath + "' is not a valid path");
                        }
                        queue.removeLast();
                    } else {
                        queue.add(element);
                    }
                }
                start = end;
            }
            StringBuffer buf = new StringBuffer();
            Iterator iter = queue.iterator();
            while (iter.hasNext()) {
                buf.append('/');
                buf.append((String)iter.next());
            }
            return buf.toString();
        }
        return absolutePath;
    }

    public static String makeCanonicalPath(String parentPath, String somePath) throws PathNotFoundException {
        if (somePath.startsWith("/")) {
            return PathUtil.makeCanonicalPath(somePath);
        }
        String absPath = (parentPath.equals("/") ? "" : parentPath) + "/" + somePath;
        return PathUtil.makeCanonicalPath(absPath);
    }

    public static String getAncestorPath(String descendantPath, int degree) throws PathNotFoundException {
        descendantPath = PathUtil.makeCanonicalPath(descendantPath);
        int pos = descendantPath.length();
        int cnt = degree;
        while (cnt-- > 0) {
            if ((pos = descendantPath.lastIndexOf(47, pos - 1)) >= 0) continue;
            throw new PathNotFoundException(degree + "nth ancestor of " + descendantPath);
        }
        String ancestorPath = descendantPath.substring(0, pos);
        return ancestorPath.equals("") ? "/" : ancestorPath;
    }

    public static String getName(String path) throws PathNotFoundException {
        int pos = (path = PathUtil.makeCanonicalPath(path)).lastIndexOf("/");
        if (pos < 0) {
            return path;
        }
        if (pos == path.length()) {
            return "";
        }
        return path.substring(pos + 1);
    }

    public static String rewriteSuffix(String path, String from, String to) throws PathNotFoundException {
        path = PathUtil.makeCanonicalPath(path);
        int pos = from.length();
        if (pos == path.length()) {
            return to;
        }
        return to + path.substring(pos);
    }

    public static boolean isDescendant(String testPath, String ancestorPath, boolean direct) {
        try {
            int depth = PathUtil.getDepth(PathUtil.makeCanonicalPath(testPath));
            if (depth == 0) {
                return false;
            }
            if (direct) {
                return PathUtil.getAncestorPath(PathUtil.makeCanonicalPath(testPath), 1).equals(PathUtil.makeCanonicalPath(ancestorPath));
            }
            for (int i = 1; i <= depth; ++i) {
                if (!PathUtil.getAncestorPath(PathUtil.makeCanonicalPath(testPath), i).equals(PathUtil.makeCanonicalPath(ancestorPath))) continue;
                return true;
            }
        }
        catch (PathNotFoundException e) {
            throw new RuntimeException("isDescendanr failed " + e);
        }
        return false;
    }

    public static int getDepth(String absolutePath) throws PathNotFoundException {
        int cnt = 0;
        String _path = PathUtil.makeCanonicalPath(absolutePath);
        for (int i = 0; i < _path.length() - 1; ++i) {
            if (_path.charAt(i) != '/') continue;
            ++cnt;
        }
        return cnt;
    }
}

