/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ldap.impl;

import java.util.Stack;
import org.exoplatform.services.exception.ExoServiceException;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.ldap.LDAPServiceContainer;
import org.exoplatform.services.ldap.impl.LDAPServiceConfig;
import org.exoplatform.services.ldap.impl.LDAPServiceImpl;
import org.exoplatform.services.log.LogService;

public class LDAPServiceContainerImpl
implements LDAPServiceContainer {
    private LDAPServiceConfig ldapServiceConfig_;
    private LogService logService_;
    private Stack pool = new Stack();
    int min = 1;
    int max = 10;

    public LDAPServiceContainerImpl(LogService lservice) throws Exception {
        this.logService_ = lservice;
        this.ldapServiceConfig_ = new LDAPServiceConfig();
        for (int i = 0; i < this.min; ++i) {
            LDAPServiceImpl service = new LDAPServiceImpl(this.logService_);
            service.connect(this.ldapServiceConfig_.SERVICES_LDAP_HOST, this.ldapServiceConfig_.SERVICES_LDAP_PORT);
            service.authenticate(this.ldapServiceConfig_.SERVICES_LDAP_BASEDN, this.ldapServiceConfig_.SERVICES_LDAP_PASSWD);
            this.pool.push(service);
        }
    }

    public LDAPService createLDAPService() throws ExoServiceException {
        LDAPService service = null;
        if (this.pool.size() > 0) {
            service = (LDAPService)this.pool.pop();
        } else {
            service = new LDAPServiceImpl(this.logService_);
            service.connect(this.ldapServiceConfig_.SERVICES_LDAP_HOST, this.ldapServiceConfig_.SERVICES_LDAP_PORT);
            service.authenticate(this.ldapServiceConfig_.SERVICES_LDAP_BASEDN, this.ldapServiceConfig_.SERVICES_LDAP_PASSWD);
        }
        return service;
    }

    public void closeLDAPService(LDAPService ldapService) throws ExoServiceException {
        if (this.pool.size() + 1 > this.max) {
            ldapService.disconnect();
        } else {
            this.pool.push(ldapService);
        }
    }
}

