/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ldap.impl;

import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import org.apache.commons.logging.Log;
import org.exoplatform.services.exception.ExoServiceException;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.LogService;

public class LDAPServiceImpl
implements LDAPService {
    private LDAPConnection conn = new LDAPConnection();
    private Log log_;

    public LDAPServiceImpl(LogService logService) {
        this.log_ = logService.getLog("org.exoplatform.services.ldap");
    }

    public void connect(String host, int port) throws ExoServiceException {
        try {
            this.conn.connect(host, port);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void authenticate(String dn, String passwd) throws ExoServiceException {
        try {
            this.conn.authenticate(dn, passwd);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void add(LDAPEntry entry) throws ExoServiceException {
        try {
            this.conn.add(entry);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void delete(String DN) throws ExoServiceException {
        try {
            this.conn.delete(DN);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void modify(String DN, LDAPModification mod) throws ExoServiceException {
        try {
            this.conn.modify(DN, mod);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public LDAPEntry read(String DN) throws ExoServiceException {
        try {
            return this.conn.read(DN);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void rename(String DN, String newRDN, boolean deleteOldRDN) throws ExoServiceException {
        try {
            this.conn.rename(DN, newRDN, deleteOldRDN);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean attrsOnly) throws ExoServiceException {
        try {
            return this.conn.search(base, scope, filter, attrs, attrsOnly);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void disconnect() throws ExoServiceException {
        try {
            this.conn.disconnect();
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void modify(String DN, LDAPModification[] mods) throws ExoServiceException {
        try {
            this.conn.modify(DN, mods);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }

    public void modify(String DN, LDAPModificationSet mods) throws ExoServiceException {
        try {
            this.conn.modify(DN, mods);
        }
        catch (LDAPException e) {
            throw new ExoServiceException((Throwable)e);
        }
    }
}

