/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.ResourceAdapterWrapper;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.DynamicGBeanDelegate;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.ResourceManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;

public class ActivationSpecWrapper
implements ResourceManager,
DynamicGBean {
    private final DynamicGBeanDelegate delegate;
    private final ActivationSpec activationSpec;
    private final ResourceAdapterWrapper resourceAdapterWrapper;
    private final String containerId;
    public static final GBeanInfo GBEAN_INFO;

    public ActivationSpecWrapper() {
        this.activationSpec = null;
        this.delegate = null;
        this.containerId = null;
        this.resourceAdapterWrapper = null;
    }

    public ActivationSpecWrapper(String activationSpecClass, String containerId, ResourceAdapterWrapper resourceAdapterWrapper, ClassLoader cl) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = cl.loadClass(activationSpecClass);
        this.activationSpec = (ActivationSpec)clazz.newInstance();
        this.delegate = new DynamicGBeanDelegate();
        this.delegate.addAll((Object)this.activationSpec);
        this.containerId = containerId;
        this.resourceAdapterWrapper = resourceAdapterWrapper;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public ResourceAdapterWrapper getResourceAdapterWrapper() {
        return this.resourceAdapterWrapper;
    }

    public Object getAttribute(String name) throws Exception {
        return this.delegate.getAttribute(name);
    }

    public void setAttribute(String name, Object value) throws Exception {
        this.delegate.setAttribute(name, value);
    }

    public Object invoke(String name, Object[] arguments, String[] types) throws Exception {
        return null;
    }

    public void activate(MessageEndpointFactory messageEndpointFactory) throws ResourceException {
        ResourceAdapter resourceAdapter = this.activationSpec.getResourceAdapter();
        if (resourceAdapter == null) {
            this.resourceAdapterWrapper.registerResourceAdapterAssociation((ResourceAdapterAssociation)this.activationSpec);
        }
        this.resourceAdapterWrapper.endpointActivation(messageEndpointFactory, this.activationSpec);
    }

    public void deactivate(MessageEndpointFactory messageEndpointFactory) {
        ResourceAdapter resourceAdapter = this.activationSpec.getResourceAdapter();
        if (resourceAdapter == null) {
            throw new IllegalStateException("ActivationSpec was never registered with ResourceAdapter");
        }
        this.resourceAdapterWrapper.endpointDeactivation(messageEndpointFactory, this.activationSpec);
    }

    public NamedXAResource getRecoveryXAResources() throws SystemException {
        if (this.resourceAdapterWrapper == null) {
            throw new IllegalStateException("Attempting to use activation spec when it is not activated");
        }
        try {
            XAResource[] xaResources = this.resourceAdapterWrapper.getXAResources(new ActivationSpec[]{this.activationSpec});
            if (xaResources == null || xaResources.length == 0) {
                return null;
            }
            return new WrapperNamedXAResource(xaResources[0], this.containerId);
        }
        catch (ResourceException e) {
            throw (SystemException)new SystemException("Could not get XAResource for recovery for mdb: " + this.containerId).initCause((Throwable)e);
        }
    }

    public void returnResource(NamedXAResource xaResource) {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(ActivationSpecWrapper.class, "JCAActivationSpec");
        infoBuilder.addAttribute("activationSpecClass", String.class, true);
        infoBuilder.addAttribute("containerId", String.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addReference("ResourceAdapterWrapper", ResourceAdapterWrapper.class, NameFactory.RESOURCE_ADAPTER);
        infoBuilder.addOperation("activate", new Class[]{MessageEndpointFactory.class});
        infoBuilder.addOperation("deactivate", new Class[]{MessageEndpointFactory.class});
        infoBuilder.addInterface(ResourceManager.class);
        infoBuilder.setConstructor(new String[]{"activationSpecClass", "containerId", "ResourceAdapterWrapper", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

