/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.geronimo.connector.BootstrapContextImpl;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.gbean.DynamicGBean;
import org.apache.geronimo.gbean.DynamicGBeanDelegate;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;

public class ResourceAdapterWrapper
implements GBeanLifecycle,
DynamicGBean,
ResourceAdapter {
    public static final GBeanInfo GBEAN_INFO;
    private final String resourceAdapterClass;
    private final BootstrapContext bootstrapContext;
    private final ResourceAdapter resourceAdapter;
    private final DynamicGBeanDelegate delegate;

    public ResourceAdapterWrapper() {
        this.resourceAdapterClass = null;
        this.bootstrapContext = null;
        this.resourceAdapter = null;
        this.delegate = null;
    }

    public ResourceAdapterWrapper(String resourceAdapterClass, GeronimoWorkManager workManager, ClassLoader cl) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.resourceAdapterClass = resourceAdapterClass;
        this.bootstrapContext = new BootstrapContextImpl(workManager);
        Class<?> clazz = cl.loadClass(resourceAdapterClass);
        this.resourceAdapter = (ResourceAdapter)clazz.newInstance();
        this.delegate = new DynamicGBeanDelegate();
        this.delegate.addAll((Object)this.resourceAdapter);
    }

    public String getResourceAdapterClass() {
        return this.resourceAdapterClass;
    }

    public void registerResourceAdapterAssociation(ResourceAdapterAssociation resourceAdapterAssociation) throws ResourceException {
        resourceAdapterAssociation.setResourceAdapter(this.resourceAdapter);
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        throw new IllegalStateException("Don't call this");
    }

    public void stop() {
        throw new IllegalStateException("Don't call this");
    }

    public void endpointActivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) throws ResourceException {
        this.resourceAdapter.endpointActivation(messageEndpointFactory, activationSpec);
    }

    public void endpointDeactivation(MessageEndpointFactory messageEndpointFactory, ActivationSpec activationSpec) {
        this.resourceAdapter.endpointDeactivation(messageEndpointFactory, activationSpec);
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return this.resourceAdapter.getXAResources(specs);
    }

    public void doStart() throws Exception {
        this.resourceAdapter.start(this.bootstrapContext);
    }

    public void doStop() {
        this.resourceAdapter.stop();
    }

    public void doFail() {
        this.resourceAdapter.stop();
    }

    public Object getAttribute(String name) throws Exception {
        return this.delegate.getAttribute(name);
    }

    public void setAttribute(String name, Object value) throws Exception {
        this.delegate.setAttribute(name, value);
    }

    public Object invoke(String name, Object[] arguments, String[] types) throws Exception {
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(ResourceAdapterWrapper.class, NameFactory.RESOURCE_ADAPTER);
        infoBuilder.addAttribute("resourceAdapterClass", String.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addReference("WorkManager", GeronimoWorkManager.class, "JCAWorkManager");
        infoBuilder.addOperation("registerResourceAdapterAssociation", new Class[]{ResourceAdapterAssociation.class});
        infoBuilder.addInterface(ResourceAdapter.class);
        infoBuilder.setConstructor(new String[]{"resourceAdapterClass", "WorkManager", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

