/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.j2ee.management.J2EEServer;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class JCAConnectionFactoryImpl {
    private final J2EEServer server;
    private final String managedConnectionFactory;
    public static final GBeanInfo GBEAN_INFO;

    public JCAConnectionFactoryImpl(String objectName, J2EEServer server, String managedConnectionFactory) {
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        this.server = server;
        this.managedConnectionFactory = managedConnectionFactory;
    }

    public String getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"JCAConnectionFactory".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("JCAConnectionFactory object name j2eeType property must be 'JCAConnectionFactory'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("JCAConnectionFactory object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("JCAConnectionFactory object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("JCAResource")) {
            throw new InvalidObjectNameException("JCAResource object name must contain a JCAResource property", objectName);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JCAConnectionFactoryImpl.class, NameFactory.JCA_CONNECTION_FACTORY);
        infoFactory.addReference("J2EEServer", J2EEServer.class);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("managedConnectionFactory", String.class, true);
        infoFactory.setConstructor(new String[]{"objectName", "J2EEServer", "managedConnectionFactory"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

