/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.apache.geronimo.connector.work.WorkerContext;
import org.apache.geronimo.connector.work.pool.NullWorkExecutorPool;
import org.apache.geronimo.connector.work.pool.ScheduleWorkExecutor;
import org.apache.geronimo.connector.work.pool.StartWorkExecutor;
import org.apache.geronimo.connector.work.pool.SyncWorkExecutor;
import org.apache.geronimo.connector.work.pool.WorkExecutor;
import org.apache.geronimo.connector.work.pool.WorkExecutorPool;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class GeronimoWorkManager
implements WorkManager,
GBeanLifecycle {
    private static final int DEFAULT_POOL_SIZE = 10;
    private WorkExecutorPool syncWorkExecutorPool;
    private WorkExecutorPool startWorkExecutorPool;
    private WorkExecutorPool scheduledWorkExecutorPool;
    private final TransactionContextManager transactionContextManager;
    private final WorkExecutor scheduleWorkExecutor = new ScheduleWorkExecutor();
    private final WorkExecutor startWorkExecutor = new StartWorkExecutor();
    private final WorkExecutor syncWorkExecutor = new SyncWorkExecutor();
    public static final GBeanInfo GBEAN_INFO;

    public GeronimoWorkManager() {
        this(10, null);
    }

    public GeronimoWorkManager(int size, TransactionContextManager transactionContextManager) {
        this(size, size, size, transactionContextManager);
    }

    public GeronimoWorkManager(int syncSize, int startSize, int schedSize, TransactionContextManager transactionContextManager) {
        this.syncWorkExecutorPool = new NullWorkExecutorPool(syncSize);
        this.startWorkExecutorPool = new NullWorkExecutorPool(startSize);
        this.scheduledWorkExecutorPool = new NullWorkExecutorPool(schedSize);
        this.transactionContextManager = transactionContextManager;
    }

    public void doStart() throws Exception {
        this.syncWorkExecutorPool = this.syncWorkExecutorPool.start();
        this.startWorkExecutorPool = this.startWorkExecutorPool.start();
        this.scheduledWorkExecutorPool = this.scheduledWorkExecutorPool.start();
    }

    public void doStop() throws Exception {
        this.syncWorkExecutorPool = this.syncWorkExecutorPool.stop();
        this.startWorkExecutorPool = this.startWorkExecutorPool.stop();
        this.scheduledWorkExecutorPool = this.scheduledWorkExecutorPool.stop();
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XATerminator getXATerminator() {
        return this.transactionContextManager;
    }

    public int getSyncThreadCount() {
        return this.syncWorkExecutorPool.getPoolSize();
    }

    public int getSyncMaximumPoolSize() {
        return this.syncWorkExecutorPool.getMaximumPoolSize();
    }

    public void setSyncMaximumPoolSize(int maxSize) {
        this.syncWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public int getStartThreadCount() {
        return this.startWorkExecutorPool.getPoolSize();
    }

    public int getStartMaximumPoolSize() {
        return this.startWorkExecutorPool.getMaximumPoolSize();
    }

    public void setStartMaximumPoolSize(int maxSize) {
        this.startWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public int getScheduledThreadCount() {
        return this.scheduledWorkExecutorPool.getPoolSize();
    }

    public int getScheduledMaximumPoolSize() {
        return this.scheduledWorkExecutorPool.getMaximumPoolSize();
    }

    public void setScheduledMaximumPoolSize(int maxSize) {
        this.scheduledWorkExecutorPool.setMaximumPoolSize(maxSize);
    }

    public void doWork(Work work) throws WorkException {
        this.executeWork(new WorkerContext(work, this.transactionContextManager), this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.transactionContextManager, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.syncWorkExecutor, this.syncWorkExecutorPool);
    }

    public long startWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, this.transactionContextManager);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public long startWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.transactionContextManager, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.startWorkExecutor, this.startWorkExecutorPool);
        return System.currentTimeMillis() - workWrapper.getAcceptedTime();
    }

    public void scheduleWork(Work work) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, this.transactionContextManager);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext execContext, WorkListener workListener) throws WorkException {
        WorkerContext workWrapper = new WorkerContext(work, startTimeout, execContext, this.transactionContextManager, workListener);
        workWrapper.setThreadPriority(Thread.currentThread().getPriority());
        this.executeWork(workWrapper, this.scheduleWorkExecutor, this.scheduledWorkExecutorPool);
    }

    private void executeWork(WorkerContext work, WorkExecutor workExecutor, Executor pooledExecutor) throws WorkException {
        work.workAccepted(this);
        try {
            workExecutor.doExecute(work, pooledExecutor);
            WorkException exception = work.getWorkException();
            if (null != exception) {
                throw exception;
            }
        }
        catch (InterruptedException e) {
            WorkCompletedException wcj = new WorkCompletedException("The execution has been interrupted.", (Throwable)e);
            wcj.setErrorCode("-1");
            throw wcj;
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(GeronimoWorkManager.class, "JCAWorkManager");
        infoFactory.addInterface(WorkManager.class);
        infoFactory.addAttribute("syncMaximumPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("startMaximumPoolSize", Integer.TYPE, true);
        infoFactory.addAttribute("scheduledMaximumPoolSize", Integer.TYPE, true);
        infoFactory.addOperation("getXATerminator");
        infoFactory.addReference("TransactionContextManager", TransactionContextManager.class, NameFactory.JTA_RESOURCE);
        infoFactory.setConstructor(new String[]{"syncMaximumPoolSize", "startMaximumPoolSize", "scheduledMaximumPoolSize", "TransactionContextManager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

