/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.management.JCAResource;

public class JCAResourceImpl
implements JCAResource {
    private final Kernel kernel;
    private final String objectName;
    private final J2eeContext moduleContext;
    private static final String[] CONNECTION_FACTORY_TYPES = new String[]{"JCAConnectionFactory"};
    private static final String[] RESOURCE_ADAPTER_INSTANCE_TYPES = new String[]{"JCAResourceAdapter"};

    public JCAResourceImpl(String objectName, Kernel kernel) {
        this.objectName = objectName;
        this.kernel = kernel;
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.moduleContext = J2eeContextImpl.newContext((ObjectName)myObjectName, (String)"JCAResource");
    }

    public String[] getConnectionFactories() {
        try {
            return Util.getObjectNames((Kernel)this.kernel, (J2eeContext)this.moduleContext, (String[])CONNECTION_FACTORY_TYPES);
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError();
        }
    }

    public String[] getResourceAdapterInstances() {
        try {
            return Util.getObjectNames((Kernel)this.kernel, (J2eeContext)this.moduleContext, (String[])RESOURCE_ADAPTER_INSTANCE_TYPES);
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError();
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }
}

